/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.payment;

import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;

public class PaymentCoreDataTO {
    public static final String SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for your one time %s order to %s at date %s; account %s; %s %s is: ";
    public static final String PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for your recurring %s order to %s; account %s; Day of execution %s; Rule %s, Frequency %s; Amount %s %s is: ";
    public static final String BULK_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for your one time bulk %s order %s reciepient(s) with name(s) %s at date %s; account %s; %s %s is: ";
    public static final String SINGLE_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "Your one time %s order to %s at date %s; account %s; %s %s has been received.";
    public static final String PERIODIC_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "Your recurring %s order to %s; account %s; Day of execution %s; Rule %s, Frequency %s; Amount %s %s  has been received.";
    public static final String BULK_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "Your one time bulk %s order %s reciepient(s) with name(s) %s at date %s; account %s; %s %s has been received.";
    public static final String CANCEL_SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for the cancellation of your one time %s order to %s at date %s; account %s; %s %s is: ";
    public static final String CANCEL_PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for the cancellation of your recurring %s order to %s; account %s; Day of execution %s; Rule %s, Frequency %s; Amount %s %s is: ";
    public static final String CANCEL_BULK_PAYMENT_TAN_MESSAGE_TEMPLATE = "The TAN for for the cancellation of your one time bulk %s order %s reciepient(s) with name(s) %s at date %s; account %s; %s %s is: ";
    public static final String CANCEL_SINGLE_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "The cancellation of your one time %s order to %s at date %s; account %s; %s %s has been scheduled.";
    public static final String CANCEL_PERIODIC_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "The cancellation of your recurring %s order to %s; account %s; Day of execution %s; Rule %s, Frequency %s; Amount %s %s has been scheduled.";
    public static final String CANCEL_BULK_PAYMENT_EXEMPTED_MESSAGE_TEMPLATE = "The cancellation of your one time bulk %s order %s reciepient(s) with name(s) %s at date %s; account %s; %s %s has been scheduled.";
    private String paymentId;
    private String creditorName;
    private String creditorIban;
    private String amount;
    private String currency;
    private String dayOfExecution;
    private String executionRule;
    private String frequency;
    private String paymentType;
    private String paymentsSize;
    private String requestedExecutionDate;
    private boolean cancellation;
    private String paymentProduct;

    public String template() {
        PaymentTypeTO pt = PaymentTypeTO.valueOf(this.paymentType);
        switch (pt) {
            case PERIODIC: {
                return this.cancellation ? this.cancelPeriodicPaymentMessageTemplate() : this.periodicPaymentMessageTemplate();
            }
            case BULK: {
                return this.cancellation ? this.cancelBulkPaymentMessageTemplate() : this.bulkPaymentMessageTemplate();
            }
        }
        return this.cancellation ? this.cancelSinglePaymentMessageTemplate() : this.singlePaymentMessageTemplate();
    }

    public String exemptedTemplate() {
        PaymentTypeTO pt = PaymentTypeTO.valueOf(this.paymentType);
        switch (pt) {
            case PERIODIC: {
                return this.cancellation ? this.cancelPeriodicPaymentExemptedMessageTemplate() : this.periodicPaymentExemptedMessageTemplate();
            }
            case BULK: {
                return this.cancellation ? this.cancelBulkPaymentExemptedMessageTemplate() : this.bulkPaymentExemptedMessageTemplate();
            }
        }
        return this.cancellation ? this.cancelSinglePaymentExemptedMessageTemplate() : this.singlePaymentExemptedMessageTemplate();
    }

    private String singlePaymentMessageTemplate() {
        return String.format(SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String periodicPaymentMessageTemplate() {
        return String.format(PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.creditorName, this.creditorIban, this.dayOfExecution, this.executionRule, this.frequency, this.currency, this.amount) + "%s";
    }

    private String bulkPaymentMessageTemplate() {
        return String.format(BULK_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.paymentsSize, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String cancelSinglePaymentMessageTemplate() {
        return String.format(CANCEL_SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String cancelPeriodicPaymentMessageTemplate() {
        return String.format(CANCEL_PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.creditorName, this.creditorIban, this.dayOfExecution, this.executionRule, this.frequency, this.currency, this.amount) + "%s";
    }

    private String cancelBulkPaymentMessageTemplate() {
        return String.format(CANCEL_BULK_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.paymentsSize, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String singlePaymentExemptedMessageTemplate() {
        return String.format(SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String periodicPaymentExemptedMessageTemplate() {
        return String.format(PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.creditorName, this.creditorIban, this.dayOfExecution, this.executionRule, this.frequency, this.currency, this.amount) + "%s";
    }

    private String bulkPaymentExemptedMessageTemplate() {
        return String.format(BULK_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.paymentsSize, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String cancelSinglePaymentExemptedMessageTemplate() {
        return String.format(CANCEL_SINGLE_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    private String cancelPeriodicPaymentExemptedMessageTemplate() {
        return String.format(CANCEL_PERIODIC_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.creditorName, this.creditorIban, this.dayOfExecution, this.executionRule, this.frequency, this.currency, this.amount) + "%s";
    }

    private String cancelBulkPaymentExemptedMessageTemplate() {
        return String.format(CANCEL_BULK_PAYMENT_TAN_MESSAGE_TEMPLATE, this.paymentProduct, this.paymentsSize, this.creditorName, this.requestedExecutionDate, this.creditorIban, this.currency, this.amount) + "%s";
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getCreditorName() {
        return this.creditorName;
    }

    public String getCreditorIban() {
        return this.creditorIban;
    }

    public String getAmount() {
        return this.amount;
    }

    public String getCurrency() {
        return this.currency;
    }

    public String getDayOfExecution() {
        return this.dayOfExecution;
    }

    public String getExecutionRule() {
        return this.executionRule;
    }

    public String getFrequency() {
        return this.frequency;
    }

    public String getPaymentType() {
        return this.paymentType;
    }

    public String getPaymentsSize() {
        return this.paymentsSize;
    }

    public String getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public boolean isCancellation() {
        return this.cancellation;
    }

    public String getPaymentProduct() {
        return this.paymentProduct;
    }

    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public void setCreditorIban(String creditorIban) {
        this.creditorIban = creditorIban;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public void setDayOfExecution(String dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public void setExecutionRule(String executionRule) {
        this.executionRule = executionRule;
    }

    public void setFrequency(String frequency) {
        this.frequency = frequency;
    }

    public void setPaymentType(String paymentType) {
        this.paymentType = paymentType;
    }

    public void setPaymentsSize(String paymentsSize) {
        this.paymentsSize = paymentsSize;
    }

    public void setRequestedExecutionDate(String requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public void setCancellation(boolean cancellation) {
        this.cancellation = cancellation;
    }

    public void setPaymentProduct(String paymentProduct) {
        this.paymentProduct = paymentProduct;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentCoreDataTO)) {
            return false;
        }
        PaymentCoreDataTO other = (PaymentCoreDataTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$creditorName = this.getCreditorName();
        String other$creditorName = other.getCreditorName();
        if (this$creditorName == null ? other$creditorName != null : !this$creditorName.equals(other$creditorName)) {
            return false;
        }
        String this$creditorIban = this.getCreditorIban();
        String other$creditorIban = other.getCreditorIban();
        if (this$creditorIban == null ? other$creditorIban != null : !this$creditorIban.equals(other$creditorIban)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$dayOfExecution = this.getDayOfExecution();
        String other$dayOfExecution = other.getDayOfExecution();
        if (this$dayOfExecution == null ? other$dayOfExecution != null : !this$dayOfExecution.equals(other$dayOfExecution)) {
            return false;
        }
        String this$executionRule = this.getExecutionRule();
        String other$executionRule = other.getExecutionRule();
        if (this$executionRule == null ? other$executionRule != null : !this$executionRule.equals(other$executionRule)) {
            return false;
        }
        String this$frequency = this.getFrequency();
        String other$frequency = other.getFrequency();
        if (this$frequency == null ? other$frequency != null : !this$frequency.equals(other$frequency)) {
            return false;
        }
        String this$paymentType = this.getPaymentType();
        String other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !this$paymentType.equals(other$paymentType)) {
            return false;
        }
        String this$paymentsSize = this.getPaymentsSize();
        String other$paymentsSize = other.getPaymentsSize();
        if (this$paymentsSize == null ? other$paymentsSize != null : !this$paymentsSize.equals(other$paymentsSize)) {
            return false;
        }
        String this$requestedExecutionDate = this.getRequestedExecutionDate();
        String other$requestedExecutionDate = other.getRequestedExecutionDate();
        if (this$requestedExecutionDate == null ? other$requestedExecutionDate != null : !this$requestedExecutionDate.equals(other$requestedExecutionDate)) {
            return false;
        }
        if (this.isCancellation() != other.isCancellation()) {
            return false;
        }
        String this$paymentProduct = this.getPaymentProduct();
        String other$paymentProduct = other.getPaymentProduct();
        return !(this$paymentProduct == null ? other$paymentProduct != null : !this$paymentProduct.equals(other$paymentProduct));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentCoreDataTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $creditorName = this.getCreditorName();
        result = result * 59 + ($creditorName == null ? 43 : $creditorName.hashCode());
        String $creditorIban = this.getCreditorIban();
        result = result * 59 + ($creditorIban == null ? 43 : $creditorIban.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $dayOfExecution = this.getDayOfExecution();
        result = result * 59 + ($dayOfExecution == null ? 43 : $dayOfExecution.hashCode());
        String $executionRule = this.getExecutionRule();
        result = result * 59 + ($executionRule == null ? 43 : $executionRule.hashCode());
        String $frequency = this.getFrequency();
        result = result * 59 + ($frequency == null ? 43 : $frequency.hashCode());
        String $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : $paymentType.hashCode());
        String $paymentsSize = this.getPaymentsSize();
        result = result * 59 + ($paymentsSize == null ? 43 : $paymentsSize.hashCode());
        String $requestedExecutionDate = this.getRequestedExecutionDate();
        result = result * 59 + ($requestedExecutionDate == null ? 43 : $requestedExecutionDate.hashCode());
        result = result * 59 + (this.isCancellation() ? 79 : 97);
        String $paymentProduct = this.getPaymentProduct();
        result = result * 59 + ($paymentProduct == null ? 43 : $paymentProduct.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentCoreDataTO(paymentId=" + this.getPaymentId() + ", creditorName=" + this.getCreditorName() + ", creditorIban=" + this.getCreditorIban() + ", amount=" + this.getAmount() + ", currency=" + this.getCurrency() + ", dayOfExecution=" + this.getDayOfExecution() + ", executionRule=" + this.getExecutionRule() + ", frequency=" + this.getFrequency() + ", paymentType=" + this.getPaymentType() + ", paymentsSize=" + this.getPaymentsSize() + ", requestedExecutionDate=" + this.getRequestedExecutionDate() + ", cancellation=" + this.isCancellation() + ", paymentProduct=" + this.getPaymentProduct() + ")";
    }

    public PaymentCoreDataTO() {
    }

    public PaymentCoreDataTO(String paymentId, String creditorName, String creditorIban, String amount, String currency, String dayOfExecution, String executionRule, String frequency, String paymentType, String paymentsSize, String requestedExecutionDate, boolean cancellation, String paymentProduct) {
        this.paymentId = paymentId;
        this.creditorName = creditorName;
        this.creditorIban = creditorIban;
        this.amount = amount;
        this.currency = currency;
        this.dayOfExecution = dayOfExecution;
        this.executionRule = executionRule;
        this.frequency = frequency;
        this.paymentType = paymentType;
        this.paymentsSize = paymentsSize;
        this.requestedExecutionDate = requestedExecutionDate;
        this.cancellation = cancellation;
        this.paymentProduct = paymentProduct;
    }
}

