/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.jaxb.api.in.ActiveOrHistoricCurrencyAndAmount;
import de.adorsys.ledgers.jaxb.api.in.AmountType3Choice;
import de.adorsys.ledgers.jaxb.api.in.CashAccount16;
import de.adorsys.ledgers.jaxb.api.in.CreditTransferTransactionInformation10;
import de.adorsys.ledgers.jaxb.api.in.PaymentIdentification1;
import de.adorsys.ledgers.jaxb.api.in.PaymentInstructionInformation3;
import de.adorsys.ledgers.jaxb.api.out.CustomerPaymentStatusReportV03;
import de.adorsys.ledgers.jaxb.api.out.Document;
import de.adorsys.ledgers.jaxb.api.out.OriginalGroupInformation20;
import de.adorsys.ledgers.jaxb.api.out.OriginalPaymentInformation1;
import de.adorsys.ledgers.jaxb.api.out.TransactionGroupStatus3Code;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.impl.converter.JaxbConverter;
import de.adorsys.ledgers.middleware.impl.converter.PainPaymentConverter;
import java.time.LocalDate;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PainPaymentConverterImpl
implements PainPaymentConverter {
    @Value(value="${currency.default:EUR}")
    private Currency defaultCurrency;
    private final JaxbConverter jaxbConverter;

    @Override
    public String toPayload(SCAPaymentResponseTO response) {
        Document payload = new Document();
        CustomerPaymentStatusReportV03 status = new CustomerPaymentStatusReportV03();
        OriginalGroupInformation20 original = new OriginalGroupInformation20();
        TransactionGroupStatus3Code transactionStatus = TransactionGroupStatus3Code.valueOf((String)response.getTransactionStatus().toString());
        original.setGrpSts(transactionStatus);
        status.setOrgnlGrpInfAndSts(original);
        OriginalPaymentInformation1 paymentInfo = new OriginalPaymentInformation1();
        paymentInfo.setPmtInfSts(transactionStatus);
        paymentInfo.setOrgnlPmtInfId(response.getPaymentId());
        status.getOrgnlPmtInfAndSts().add(paymentInfo);
        payload.setCstmrPmtStsRpt(status);
        return this.jaxbConverter.fromObject(payload).orElseThrow(() -> MiddlewareModuleException.builder().devMsg("Couldn't convert object to payment object.").errorCode(MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE).build());
    }

    @Override
    public PaymentBO toPaymentBO(String payment, PaymentTypeTO paymentType) {
        de.adorsys.ledgers.jaxb.api.in.Document document = this.jaxbConverter.toObject(payment, de.adorsys.ledgers.jaxb.api.in.Document.class).orElseThrow(() -> MiddlewareModuleException.builder().devMsg("Couldn't convert xml to payment object.").errorCode(MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE).build());
        PaymentBO paymentBO = new PaymentBO();
        paymentBO.setPaymentType(PaymentTypeBO.valueOf((String)paymentType.name()));
        paymentBO.setPaymentProduct(((PaymentInstructionInformation3)document.getCstmrCdtTrfInitn().getPmtInves().get(0)).getPmtTpInf().getSvcLvl().getCd());
        paymentBO.setTargets(this.buildPaymentTargets(document));
        paymentBO.setDebtorAccount(this.buildAccountReferenceBO(this.getDebtorAccount(document)));
        paymentBO.setRequestedExecutionDate(this.buildRequestedExecutionDate(document));
        return paymentBO;
    }

    private LocalDate buildRequestedExecutionDate(de.adorsys.ledgers.jaxb.api.in.Document document) {
        XMLGregorianCalendar reqdExctnDt = ((PaymentInstructionInformation3)document.getCstmrCdtTrfInitn().getPmtInves().get(0)).getReqdExctnDt();
        return LocalDate.of(reqdExctnDt.getYear(), reqdExctnDt.getMonth(), reqdExctnDt.getDay());
    }

    private List<PaymentTargetBO> buildPaymentTargets(de.adorsys.ledgers.jaxb.api.in.Document painPayment) {
        return painPayment.getCstmrCdtTrfInitn().getPmtInves().stream().map(this::buildPaymentTargetBO).collect(Collectors.toList());
    }

    private CashAccount16 getDebtorAccount(de.adorsys.ledgers.jaxb.api.in.Document painPayment) {
        PaymentInstructionInformation3 paymentInstructionInformation3 = (PaymentInstructionInformation3)painPayment.getCstmrCdtTrfInitn().getPmtInves().get(0);
        return paymentInstructionInformation3.getDbtrAcct();
    }

    private PaymentTargetBO buildPaymentTargetBO(PaymentInstructionInformation3 paymentInfo) {
        CreditTransferTransactionInformation10 creditTransferInfo = this.getCreditTransferTransactionInformation(paymentInfo);
        PaymentIdentification1 pmtId = creditTransferInfo.getPmtId();
        PaymentTargetBO target = new PaymentTargetBO();
        target.setCreditorName(creditTransferInfo.getCdtr().getNm());
        target.setEndToEndIdentification(pmtId.getEndToEndId());
        target.setCreditorName(creditTransferInfo.getCdtr().getNm());
        target.setCreditorAccount(this.buildAccountReferenceBO(creditTransferInfo.getCdtrAcct()));
        target.setRemittanceInformationUnstructured((String)creditTransferInfo.getRmtInf().getUstrds().get(0));
        target.setInstructedAmount(this.buildAmountBO(creditTransferInfo.getAmt()));
        return target;
    }

    private AmountBO buildAmountBO(AmountType3Choice amount) {
        ActiveOrHistoricCurrencyAndAmount instdAmt = amount.getInstdAmt();
        return new AmountBO(this.buildCurrency(instdAmt.getCcy()), instdAmt.getValue());
    }

    private AccountReferenceBO buildAccountReferenceBO(CashAccount16 cashAccount) {
        AccountReferenceBO account = new AccountReferenceBO();
        account.setIban(cashAccount.getId().getIBAN());
        account.setCurrency(this.buildCurrency(cashAccount.getCcy()));
        return account;
    }

    private Currency buildCurrency(String currency) {
        return StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{currency}) ? Currency.getInstance(currency) : this.defaultCurrency;
    }

    private CreditTransferTransactionInformation10 getCreditTransferTransactionInformation(PaymentInstructionInformation3 paymentInfo) {
        return (CreditTransferTransactionInformation10)paymentInfo.getCdtTrfTxInves().get(0);
    }

    public PainPaymentConverterImpl(JaxbConverter jaxbConverter) {
        this.jaxbConverter = jaxbConverter;
    }
}

