/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.AuthConfirmationTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAuthConfirmationService;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.ScaAuthConfirmationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import java.util.EnumSet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareAuthConfirmationServiceImpl
implements MiddlewareAuthConfirmationService {
    private final SCAOperationService scaOperationService;
    private final DepositAccountPaymentService depositAccountPaymentService;
    @Value(value="${sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public AuthConfirmationTO verifyAuthConfirmationCode(String authorisationId, String authConfirmCode, String userLogin) {
        ScaAuthConfirmationBO authConfirmationBO = this.scaOperationService.verifyAuthConfirmationCode(authorisationId, authConfirmCode);
        if (!authConfirmationBO.isConfirm()) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.AUTHENTICATION_FAILURE).devMsg("Auth confirmation code is invalid").build();
        }
        AuthConfirmationTO authConfirmation = new AuthConfirmationTO();
        boolean authCompleted = this.scaOperationService.authenticationCompleted(authConfirmationBO.getOpId(), authConfirmationBO.getOpTypeBO());
        if (EnumSet.of(OpTypeBO.PAYMENT, OpTypeBO.CANCEL_PAYMENT).contains(authConfirmationBO.getOpTypeBO())) {
            if (authCompleted) {
                this.depositAccountPaymentService.updatePaymentStatus(authConfirmationBO.getOpId(), TransactionStatusBO.ACTC);
                TransactionStatusBO status = this.depositAccountPaymentService.executePayment(authConfirmationBO.getOpId(), userLogin);
                authConfirmation.setTransactionStatus(TransactionStatusTO.valueOf((String)status.toString()));
            } else if (this.multilevelScaEnable) {
                TransactionStatusBO status = this.depositAccountPaymentService.updatePaymentStatus(authConfirmationBO.getOpId(), TransactionStatusBO.PATC);
                authConfirmation.setTransactionStatus(TransactionStatusTO.valueOf((String)status.toString()));
            }
        } else if (OpTypeBO.CONSENT == authConfirmationBO.getOpTypeBO() && !authCompleted) {
            authConfirmation.setPartiallyAuthorised(this.multilevelScaEnable);
            authConfirmation.setMultilevelScaRequired(this.multilevelScaEnable);
        }
        return authConfirmation;
    }

    public MiddlewareAuthConfirmationServiceImpl(SCAOperationService scaOperationService, DepositAccountPaymentService depositAccountPaymentService) {
        this.scaOperationService = scaOperationService;
        this.depositAccountPaymentService = depositAccountPaymentService;
    }
}

