/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.middleware.api.domain.oauth.OauthCodeResponseTO;
import de.adorsys.ledgers.middleware.api.domain.oauth.OauthServerInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOauthService;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.OauthServerInfoMapper;
import de.adorsys.ledgers.um.api.domain.oauth.OauthCodeResponseBO;
import de.adorsys.ledgers.um.api.domain.oauth.OauthTokenResponseBO;
import de.adorsys.ledgers.um.api.service.OauthAuthorisationService;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareOauthServiceImpl
implements MiddlewareOauthService {
    private static final String OAUTH_CODE_PARAM = "?code=";
    private final BearerTokenMapper bearerTokenMapper;
    private final OauthAuthorisationService oauthAuthorisationService;
    private final OauthServerInfoMapper oauthServerInfoMapper;

    public OauthCodeResponseTO oauthCode(String login, String pin, String redirectUri) {
        OauthCodeResponseBO response = this.oauthAuthorisationService.oauthCode(login, pin);
        return new OauthCodeResponseTO(redirectUri + OAUTH_CODE_PARAM + response.getCode());
    }

    public OauthCodeResponseTO oauthCode(String userId, String redirectUri) {
        OauthCodeResponseBO response = this.oauthAuthorisationService.oauthCode(userId);
        return new OauthCodeResponseTO(redirectUri + OAUTH_CODE_PARAM + response.getCode());
    }

    public BearerTokenTO oauthToken(String code) {
        OauthTokenResponseBO response = this.oauthAuthorisationService.oauthToken(code);
        return this.bearerTokenMapper.toBearerTokenTO(response.getBearerTokenBO());
    }

    public OauthServerInfoTO oauthServerInfo() {
        return this.oauthServerInfoMapper.toOauthServerInfoTO(this.oauthAuthorisationService.oauthServerInfo());
    }

    public MiddlewareOauthServiceImpl(BearerTokenMapper bearerTokenMapper, OauthAuthorisationService oauthAuthorisationService, OauthServerInfoMapper oauthServerInfoMapper) {
        this.bearerTokenMapper = bearerTokenMapper;
        this.oauthAuthorisationService = oauthAuthorisationService;
        this.oauthServerInfoMapper = oauthServerInfoMapper;
    }
}

