/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.converter;

import de.adorsys.ledgers.postings.api.domain.AccountCategoryBO;
import de.adorsys.ledgers.postings.api.domain.AccountStmtBO;
import de.adorsys.ledgers.postings.api.domain.BalanceSideBO;
import de.adorsys.ledgers.postings.api.domain.ChartOfAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.domain.PostingTraceBO;
import de.adorsys.ledgers.postings.api.domain.StmtStatusBO;
import de.adorsys.ledgers.postings.db.domain.AccountCategory;
import de.adorsys.ledgers.postings.db.domain.AccountStmt;
import de.adorsys.ledgers.postings.db.domain.BalanceSide;
import de.adorsys.ledgers.postings.db.domain.ChartOfAccount;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.domain.PostingTrace;
import de.adorsys.ledgers.postings.db.domain.StmtStatus;
import de.adorsys.ledgers.postings.impl.converter.AccountStmtMapper;
import de.adorsys.ledgers.postings.impl.converter.PostingMapper;
import org.mapstruct.factory.Mappers;

public class AccountStmtMapperImpl
implements AccountStmtMapper {
    private final PostingMapper postingMapper = (PostingMapper)Mappers.getMapper(PostingMapper.class);

    @Override
    public AccountStmtBO toAccountStmtBO(AccountStmt accountStmt) {
        if (accountStmt == null) {
            return null;
        }
        AccountStmtBO accountStmtBO = new AccountStmtBO();
        accountStmtBO.setId(accountStmt.getId());
        accountStmtBO.setPosting(this.postingMapper.toPostingBO(accountStmt.getPosting()));
        accountStmtBO.setPstTime(accountStmt.getPstTime());
        accountStmtBO.setStmtStatus(this.stmtStatusToStmtStatusBO(accountStmt.getStmtStatus()));
        accountStmtBO.setLatestPst(this.postingTraceToPostingTraceBO(accountStmt.getLatestPst()));
        accountStmtBO.setStmtSeqNbr(accountStmt.getStmtSeqNbr());
        accountStmtBO.setAccount(this.ledgerAccountToLedgerAccountBO(accountStmt.getAccount()));
        accountStmtBO.setYoungestPst(this.postingTraceToPostingTraceBO(accountStmt.getYoungestPst()));
        accountStmtBO.setTotalDebit(accountStmt.getTotalDebit());
        accountStmtBO.setTotalCredit(accountStmt.getTotalCredit());
        return accountStmtBO;
    }

    @Override
    public AccountStmt toAccountStmt(AccountStmtBO accountStmt) {
        if (accountStmt == null) {
            return null;
        }
        AccountStmt accountStmt1 = new AccountStmt();
        accountStmt1.setId(accountStmt.getId());
        accountStmt1.setPosting(this.postingMapper.toPosting(accountStmt.getPosting()));
        accountStmt1.setPstTime(accountStmt.getPstTime());
        accountStmt1.setStmtStatus(this.stmtStatusBOToStmtStatus(accountStmt.getStmtStatus()));
        accountStmt1.setLatestPst(this.postingTraceBOToPostingTrace(accountStmt.getLatestPst()));
        accountStmt1.setStmtSeqNbr(accountStmt.getStmtSeqNbr());
        accountStmt1.setAccount(this.ledgerAccountBOToLedgerAccount(accountStmt.getAccount()));
        accountStmt1.setYoungestPst(this.postingTraceBOToPostingTrace(accountStmt.getYoungestPst()));
        accountStmt1.setTotalDebit(accountStmt.getTotalDebit());
        accountStmt1.setTotalCredit(accountStmt.getTotalCredit());
        return accountStmt1;
    }

    protected StmtStatusBO stmtStatusToStmtStatusBO(StmtStatus stmtStatus) {
        StmtStatusBO stmtStatusBO;
        if (stmtStatus == null) {
            return null;
        }
        switch (stmtStatus) {
            case SIMULATED: {
                stmtStatusBO = StmtStatusBO.SIMULATED;
                break;
            }
            case CLOSED: {
                stmtStatusBO = StmtStatusBO.CLOSED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + stmtStatus);
            }
        }
        return stmtStatusBO;
    }

    protected ChartOfAccountBO chartOfAccountToChartOfAccountBO(ChartOfAccount chartOfAccount) {
        if (chartOfAccount == null) {
            return null;
        }
        ChartOfAccountBO chartOfAccountBO = new ChartOfAccountBO();
        chartOfAccountBO.setName(chartOfAccount.getName());
        chartOfAccountBO.setId(chartOfAccount.getId());
        chartOfAccountBO.setCreated(chartOfAccount.getCreated());
        chartOfAccountBO.setUserDetails(chartOfAccount.getUserDetails());
        chartOfAccountBO.setShortDesc(chartOfAccount.getShortDesc());
        chartOfAccountBO.setLongDesc(chartOfAccount.getLongDesc());
        return chartOfAccountBO;
    }

    protected LedgerBO ledgerToLedgerBO(Ledger ledger) {
        if (ledger == null) {
            return null;
        }
        LedgerBO ledgerBO = new LedgerBO();
        ledgerBO.setName(ledger.getName());
        ledgerBO.setId(ledger.getId());
        ledgerBO.setCreated(ledger.getCreated());
        ledgerBO.setUserDetails(ledger.getUserDetails());
        ledgerBO.setShortDesc(ledger.getShortDesc());
        ledgerBO.setLongDesc(ledger.getLongDesc());
        ledgerBO.setCoa(this.chartOfAccountToChartOfAccountBO(ledger.getCoa()));
        return ledgerBO;
    }

    protected BalanceSideBO balanceSideToBalanceSideBO(BalanceSide balanceSide) {
        BalanceSideBO balanceSideBO;
        if (balanceSide == null) {
            return null;
        }
        switch (balanceSide) {
            case Dr: {
                balanceSideBO = BalanceSideBO.Dr;
                break;
            }
            case Cr: {
                balanceSideBO = BalanceSideBO.Cr;
                break;
            }
            case DrCr: {
                balanceSideBO = BalanceSideBO.DrCr;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + balanceSide);
            }
        }
        return balanceSideBO;
    }

    protected AccountCategoryBO accountCategoryToAccountCategoryBO(AccountCategory accountCategory) {
        AccountCategoryBO accountCategoryBO;
        if (accountCategory == null) {
            return null;
        }
        switch (accountCategory) {
            case RE: {
                accountCategoryBO = AccountCategoryBO.RE;
                break;
            }
            case EX: {
                accountCategoryBO = AccountCategoryBO.EX;
                break;
            }
            case AS: {
                accountCategoryBO = AccountCategoryBO.AS;
                break;
            }
            case LI: {
                accountCategoryBO = AccountCategoryBO.LI;
                break;
            }
            case EQ: {
                accountCategoryBO = AccountCategoryBO.EQ;
                break;
            }
            case NOOP: {
                accountCategoryBO = AccountCategoryBO.NOOP;
                break;
            }
            case NORE: {
                accountCategoryBO = AccountCategoryBO.NORE;
                break;
            }
            case NOEX: {
                accountCategoryBO = AccountCategoryBO.NOEX;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountCategory);
            }
        }
        return accountCategoryBO;
    }

    protected LedgerAccountBO ledgerAccountToLedgerAccountBO(LedgerAccount ledgerAccount) {
        if (ledgerAccount == null) {
            return null;
        }
        LedgerAccountBO ledgerAccountBO = new LedgerAccountBO();
        ledgerAccountBO.setName(ledgerAccount.getName());
        ledgerAccountBO.setId(ledgerAccount.getId());
        ledgerAccountBO.setCreated(ledgerAccount.getCreated());
        ledgerAccountBO.setUserDetails(ledgerAccount.getUserDetails());
        ledgerAccountBO.setShortDesc(ledgerAccount.getShortDesc());
        ledgerAccountBO.setLongDesc(ledgerAccount.getLongDesc());
        ledgerAccountBO.setLedger(this.ledgerToLedgerBO(ledgerAccount.getLedger()));
        ledgerAccountBO.setParent(this.ledgerAccountToLedgerAccountBO(ledgerAccount.getParent()));
        ledgerAccountBO.setCoa(this.chartOfAccountToChartOfAccountBO(ledgerAccount.getCoa()));
        ledgerAccountBO.setBalanceSide(this.balanceSideToBalanceSideBO(ledgerAccount.getBalanceSide()));
        ledgerAccountBO.setCategory(this.accountCategoryToAccountCategoryBO(ledgerAccount.getCategory()));
        return ledgerAccountBO;
    }

    protected PostingTraceBO postingTraceToPostingTraceBO(PostingTrace postingTrace) {
        if (postingTrace == null) {
            return null;
        }
        PostingTraceBO postingTraceBO = new PostingTraceBO();
        postingTraceBO.setId(postingTrace.getId());
        postingTraceBO.setTgtPstId(postingTrace.getTgtPstId());
        postingTraceBO.setSrcPstTime(postingTrace.getSrcPstTime());
        postingTraceBO.setSrcPstId(postingTrace.getSrcPstId());
        postingTraceBO.setSrcOprId(postingTrace.getSrcOprId());
        postingTraceBO.setAccount(this.ledgerAccountToLedgerAccountBO(postingTrace.getAccount()));
        postingTraceBO.setDebitAmount(postingTrace.getDebitAmount());
        postingTraceBO.setCreditAmount(postingTrace.getCreditAmount());
        postingTraceBO.setSrcPstHash(postingTrace.getSrcPstHash());
        return postingTraceBO;
    }

    protected StmtStatus stmtStatusBOToStmtStatus(StmtStatusBO stmtStatusBO) {
        StmtStatus stmtStatus;
        if (stmtStatusBO == null) {
            return null;
        }
        switch (stmtStatusBO) {
            case SIMULATED: {
                stmtStatus = StmtStatus.SIMULATED;
                break;
            }
            case CLOSED: {
                stmtStatus = StmtStatus.CLOSED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + stmtStatusBO);
            }
        }
        return stmtStatus;
    }

    protected ChartOfAccount chartOfAccountBOToChartOfAccount(ChartOfAccountBO chartOfAccountBO) {
        if (chartOfAccountBO == null) {
            return null;
        }
        ChartOfAccount chartOfAccount = new ChartOfAccount();
        chartOfAccount.setId(chartOfAccountBO.getId());
        chartOfAccount.setCreated(chartOfAccountBO.getCreated());
        chartOfAccount.setUserDetails(chartOfAccountBO.getUserDetails());
        chartOfAccount.setShortDesc(chartOfAccountBO.getShortDesc());
        chartOfAccount.setLongDesc(chartOfAccountBO.getLongDesc());
        chartOfAccount.setName(chartOfAccountBO.getName());
        return chartOfAccount;
    }

    protected Ledger ledgerBOToLedger(LedgerBO ledgerBO) {
        if (ledgerBO == null) {
            return null;
        }
        Ledger ledger = new Ledger();
        ledger.setId(ledgerBO.getId());
        ledger.setCreated(ledgerBO.getCreated());
        ledger.setUserDetails(ledgerBO.getUserDetails());
        ledger.setShortDesc(ledgerBO.getShortDesc());
        ledger.setLongDesc(ledgerBO.getLongDesc());
        ledger.setName(ledgerBO.getName());
        ledger.setCoa(this.chartOfAccountBOToChartOfAccount(ledgerBO.getCoa()));
        return ledger;
    }

    protected BalanceSide balanceSideBOToBalanceSide(BalanceSideBO balanceSideBO) {
        BalanceSide balanceSide;
        if (balanceSideBO == null) {
            return null;
        }
        switch (balanceSideBO) {
            case Dr: {
                balanceSide = BalanceSide.Dr;
                break;
            }
            case Cr: {
                balanceSide = BalanceSide.Cr;
                break;
            }
            case DrCr: {
                balanceSide = BalanceSide.DrCr;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + balanceSideBO);
            }
        }
        return balanceSide;
    }

    protected AccountCategory accountCategoryBOToAccountCategory(AccountCategoryBO accountCategoryBO) {
        AccountCategory accountCategory;
        if (accountCategoryBO == null) {
            return null;
        }
        switch (accountCategoryBO) {
            case RE: {
                accountCategory = AccountCategory.RE;
                break;
            }
            case EX: {
                accountCategory = AccountCategory.EX;
                break;
            }
            case AS: {
                accountCategory = AccountCategory.AS;
                break;
            }
            case LI: {
                accountCategory = AccountCategory.LI;
                break;
            }
            case EQ: {
                accountCategory = AccountCategory.EQ;
                break;
            }
            case NOOP: {
                accountCategory = AccountCategory.NOOP;
                break;
            }
            case NORE: {
                accountCategory = AccountCategory.NORE;
                break;
            }
            case NOEX: {
                accountCategory = AccountCategory.NOEX;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountCategoryBO);
            }
        }
        return accountCategory;
    }

    protected LedgerAccount ledgerAccountBOToLedgerAccount(LedgerAccountBO ledgerAccountBO) {
        if (ledgerAccountBO == null) {
            return null;
        }
        LedgerAccount ledgerAccount = new LedgerAccount();
        ledgerAccount.setId(ledgerAccountBO.getId());
        ledgerAccount.setCreated(ledgerAccountBO.getCreated());
        ledgerAccount.setUserDetails(ledgerAccountBO.getUserDetails());
        ledgerAccount.setShortDesc(ledgerAccountBO.getShortDesc());
        ledgerAccount.setLongDesc(ledgerAccountBO.getLongDesc());
        ledgerAccount.setName(ledgerAccountBO.getName());
        ledgerAccount.setLedger(this.ledgerBOToLedger(ledgerAccountBO.getLedger()));
        ledgerAccount.setParent(this.ledgerAccountBOToLedgerAccount(ledgerAccountBO.getParent()));
        ledgerAccount.setCoa(this.chartOfAccountBOToChartOfAccount(ledgerAccountBO.getCoa()));
        ledgerAccount.setBalanceSide(this.balanceSideBOToBalanceSide(ledgerAccountBO.getBalanceSide()));
        ledgerAccount.setCategory(this.accountCategoryBOToAccountCategory(ledgerAccountBO.getCategory()));
        return ledgerAccount;
    }

    protected PostingTrace postingTraceBOToPostingTrace(PostingTraceBO postingTraceBO) {
        if (postingTraceBO == null) {
            return null;
        }
        PostingTrace postingTrace = new PostingTrace();
        postingTrace.setId(postingTraceBO.getId());
        postingTrace.setTgtPstId(postingTraceBO.getTgtPstId());
        postingTrace.setSrcPstTime(postingTraceBO.getSrcPstTime());
        postingTrace.setSrcPstId(postingTraceBO.getSrcPstId());
        postingTrace.setSrcOprId(postingTraceBO.getSrcOprId());
        postingTrace.setAccount(this.ledgerAccountBOToLedgerAccount(postingTraceBO.getAccount()));
        postingTrace.setDebitAmount(postingTraceBO.getDebitAmount());
        postingTrace.setCreditAmount(postingTraceBO.getCreditAmount());
        postingTrace.setSrcPstHash(postingTraceBO.getSrcPstHash());
        return postingTrace;
    }
}

