/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.converter;

import de.adorsys.ledgers.postings.api.domain.AccountCategoryBO;
import de.adorsys.ledgers.postings.api.domain.BalanceSideBO;
import de.adorsys.ledgers.postings.api.domain.ChartOfAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.db.domain.AccountCategory;
import de.adorsys.ledgers.postings.db.domain.BalanceSide;
import de.adorsys.ledgers.postings.db.domain.ChartOfAccount;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.impl.converter.LedgerAccountMapper;
import de.adorsys.ledgers.postings.impl.converter.LedgerMapper;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class LedgerAccountMapperImpl
implements LedgerAccountMapper {
    private final LedgerMapper ledgerMapper = (LedgerMapper)Mappers.getMapper(LedgerMapper.class);

    @Override
    public LedgerAccountBO toLedgerAccountBO(LedgerAccount ledgerAccount) {
        if (ledgerAccount == null) {
            return null;
        }
        LedgerAccountBO ledgerAccountBO = new LedgerAccountBO();
        ledgerAccountBO.setName(ledgerAccount.getName());
        ledgerAccountBO.setId(ledgerAccount.getId());
        ledgerAccountBO.setCreated(ledgerAccount.getCreated());
        ledgerAccountBO.setUserDetails(ledgerAccount.getUserDetails());
        ledgerAccountBO.setShortDesc(ledgerAccount.getShortDesc());
        ledgerAccountBO.setLongDesc(ledgerAccount.getLongDesc());
        ledgerAccountBO.setLedger(this.ledgerMapper.toLedgerBO(ledgerAccount.getLedger()));
        ledgerAccountBO.setParent(this.toLedgerAccountBO(ledgerAccount.getParent()));
        ledgerAccountBO.setCoa(this.chartOfAccountToChartOfAccountBO(ledgerAccount.getCoa()));
        ledgerAccountBO.setBalanceSide(this.balanceSideToBalanceSideBO(ledgerAccount.getBalanceSide()));
        ledgerAccountBO.setCategory(this.accountCategoryToAccountCategoryBO(ledgerAccount.getCategory()));
        return ledgerAccountBO;
    }

    @Override
    public LedgerAccount toLedgerAccount(LedgerAccountBO ledgerAccount) {
        if (ledgerAccount == null) {
            return null;
        }
        LedgerAccount ledgerAccount1 = new LedgerAccount();
        ledgerAccount1.setLedger(this.ledgerMapper.toLedger(ledgerAccount.getLedger()));
        ledgerAccount1.setParent(this.toLedgerAccount(ledgerAccount.getParent()));
        ledgerAccount1.setCoa(this.chartOfAccountBOToChartOfAccount(ledgerAccount.getCoa()));
        ledgerAccount1.setBalanceSide(this.balanceSideBOToBalanceSide(ledgerAccount.getBalanceSide()));
        ledgerAccount1.setName(ledgerAccount.getName());
        ledgerAccount1.setCategory(this.accountCategoryBOToAccountCategory(ledgerAccount.getCategory()));
        ledgerAccount1.setId(ledgerAccount.getId());
        ledgerAccount1.setCreated(ledgerAccount.getCreated());
        ledgerAccount1.setUserDetails(ledgerAccount.getUserDetails());
        ledgerAccount1.setShortDesc(ledgerAccount.getShortDesc());
        ledgerAccount1.setLongDesc(ledgerAccount.getLongDesc());
        return ledgerAccount1;
    }

    @Override
    public List<LedgerAccountBO> toLedgerAccountsBO(List<LedgerAccount> accounts) {
        if (accounts == null) {
            return null;
        }
        ArrayList<LedgerAccountBO> list = new ArrayList<LedgerAccountBO>(accounts.size());
        for (LedgerAccount ledgerAccount : accounts) {
            list.add(this.toLedgerAccountBO(ledgerAccount));
        }
        return list;
    }

    protected ChartOfAccountBO chartOfAccountToChartOfAccountBO(ChartOfAccount chartOfAccount) {
        if (chartOfAccount == null) {
            return null;
        }
        ChartOfAccountBO chartOfAccountBO = new ChartOfAccountBO();
        chartOfAccountBO.setName(chartOfAccount.getName());
        chartOfAccountBO.setId(chartOfAccount.getId());
        chartOfAccountBO.setCreated(chartOfAccount.getCreated());
        chartOfAccountBO.setUserDetails(chartOfAccount.getUserDetails());
        chartOfAccountBO.setShortDesc(chartOfAccount.getShortDesc());
        chartOfAccountBO.setLongDesc(chartOfAccount.getLongDesc());
        return chartOfAccountBO;
    }

    protected BalanceSideBO balanceSideToBalanceSideBO(BalanceSide balanceSide) {
        BalanceSideBO balanceSideBO;
        if (balanceSide == null) {
            return null;
        }
        switch (balanceSide) {
            case Dr: {
                balanceSideBO = BalanceSideBO.Dr;
                break;
            }
            case Cr: {
                balanceSideBO = BalanceSideBO.Cr;
                break;
            }
            case DrCr: {
                balanceSideBO = BalanceSideBO.DrCr;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + balanceSide);
            }
        }
        return balanceSideBO;
    }

    protected AccountCategoryBO accountCategoryToAccountCategoryBO(AccountCategory accountCategory) {
        AccountCategoryBO accountCategoryBO;
        if (accountCategory == null) {
            return null;
        }
        switch (accountCategory) {
            case RE: {
                accountCategoryBO = AccountCategoryBO.RE;
                break;
            }
            case EX: {
                accountCategoryBO = AccountCategoryBO.EX;
                break;
            }
            case AS: {
                accountCategoryBO = AccountCategoryBO.AS;
                break;
            }
            case LI: {
                accountCategoryBO = AccountCategoryBO.LI;
                break;
            }
            case EQ: {
                accountCategoryBO = AccountCategoryBO.EQ;
                break;
            }
            case NOOP: {
                accountCategoryBO = AccountCategoryBO.NOOP;
                break;
            }
            case NORE: {
                accountCategoryBO = AccountCategoryBO.NORE;
                break;
            }
            case NOEX: {
                accountCategoryBO = AccountCategoryBO.NOEX;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountCategory);
            }
        }
        return accountCategoryBO;
    }

    protected ChartOfAccount chartOfAccountBOToChartOfAccount(ChartOfAccountBO chartOfAccountBO) {
        if (chartOfAccountBO == null) {
            return null;
        }
        ChartOfAccount chartOfAccount = new ChartOfAccount();
        chartOfAccount.setId(chartOfAccountBO.getId());
        chartOfAccount.setCreated(chartOfAccountBO.getCreated());
        chartOfAccount.setUserDetails(chartOfAccountBO.getUserDetails());
        chartOfAccount.setShortDesc(chartOfAccountBO.getShortDesc());
        chartOfAccount.setLongDesc(chartOfAccountBO.getLongDesc());
        chartOfAccount.setName(chartOfAccountBO.getName());
        return chartOfAccount;
    }

    protected BalanceSide balanceSideBOToBalanceSide(BalanceSideBO balanceSideBO) {
        BalanceSide balanceSide;
        if (balanceSideBO == null) {
            return null;
        }
        switch (balanceSideBO) {
            case Dr: {
                balanceSide = BalanceSide.Dr;
                break;
            }
            case Cr: {
                balanceSide = BalanceSide.Cr;
                break;
            }
            case DrCr: {
                balanceSide = BalanceSide.DrCr;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + balanceSideBO);
            }
        }
        return balanceSide;
    }

    protected AccountCategory accountCategoryBOToAccountCategory(AccountCategoryBO accountCategoryBO) {
        AccountCategory accountCategory;
        if (accountCategoryBO == null) {
            return null;
        }
        switch (accountCategoryBO) {
            case RE: {
                accountCategory = AccountCategory.RE;
                break;
            }
            case EX: {
                accountCategory = AccountCategory.EX;
                break;
            }
            case AS: {
                accountCategory = AccountCategory.AS;
                break;
            }
            case LI: {
                accountCategory = AccountCategory.LI;
                break;
            }
            case EQ: {
                accountCategory = AccountCategory.EQ;
                break;
            }
            case NOOP: {
                accountCategory = AccountCategory.NOOP;
                break;
            }
            case NORE: {
                accountCategory = AccountCategory.NORE;
                break;
            }
            case NOEX: {
                accountCategory = AccountCategory.NOEX;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountCategoryBO);
            }
        }
        return accountCategory;
    }
}

