/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.converter;

import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.postings.api.domain.PostingStatusBO;
import de.adorsys.ledgers.postings.api.domain.PostingTypeBO;
import de.adorsys.ledgers.postings.db.domain.OperationDetails;
import de.adorsys.ledgers.postings.db.domain.PostingLine;
import de.adorsys.ledgers.postings.db.domain.PostingStatus;
import de.adorsys.ledgers.postings.db.domain.PostingType;
import de.adorsys.ledgers.postings.impl.converter.LedgerAccountMapper;
import de.adorsys.ledgers.postings.impl.converter.PostingLineMapper;
import org.mapstruct.factory.Mappers;

public class PostingLineMapperImpl
implements PostingLineMapper {
    private final LedgerAccountMapper ledgerAccountMapper = (LedgerAccountMapper)Mappers.getMapper(LedgerAccountMapper.class);

    @Override
    public PostingLineBO toPostingLineBO(PostingLine posting) {
        if (posting == null) {
            return null;
        }
        PostingLineBO postingLineBO = new PostingLineBO();
        postingLineBO.setDetails(this.postingDetailsOpDetails(posting));
        postingLineBO.setId(posting.getId());
        postingLineBO.setAccount(this.ledgerAccountMapper.toLedgerAccountBO(posting.getAccount()));
        postingLineBO.setDebitAmount(posting.getDebitAmount());
        postingLineBO.setCreditAmount(posting.getCreditAmount());
        postingLineBO.setSrcAccount(posting.getSrcAccount());
        postingLineBO.setBaseLine(posting.getBaseLine());
        postingLineBO.setSubOprSrcId(posting.getSubOprSrcId());
        postingLineBO.setRecordTime(posting.getRecordTime());
        postingLineBO.setOprId(posting.getOprId());
        postingLineBO.setOprSrc(posting.getOprSrc());
        postingLineBO.setPstTime(posting.getPstTime());
        postingLineBO.setPstType(this.postingTypeToPostingTypeBO(posting.getPstType()));
        postingLineBO.setPstStatus(this.postingStatusToPostingStatusBO(posting.getPstStatus()));
        postingLineBO.setHash(posting.getHash());
        postingLineBO.setDiscardedTime(posting.getDiscardedTime());
        return postingLineBO;
    }

    @Override
    public PostingLine toPostingLine(PostingLineBO posting) {
        if (posting == null) {
            return null;
        }
        PostingLine postingLine = new PostingLine();
        postingLine.setId(posting.getId());
        postingLine.setAccount(this.ledgerAccountMapper.toLedgerAccount(posting.getAccount()));
        postingLine.setDebitAmount(posting.getDebitAmount());
        postingLine.setCreditAmount(posting.getCreditAmount());
        postingLine.setDetails(this.stringToOperationDetails(posting.getDetails()));
        postingLine.setSrcAccount(posting.getSrcAccount());
        postingLine.setBaseLine(posting.getBaseLine());
        postingLine.setSubOprSrcId(posting.getSubOprSrcId());
        postingLine.setRecordTime(posting.getRecordTime());
        postingLine.setOprId(posting.getOprId());
        postingLine.setOprSrc(posting.getOprSrc());
        postingLine.setPstTime(posting.getPstTime());
        postingLine.setPstType(this.postingTypeBOToPostingType(posting.getPstType()));
        postingLine.setPstStatus(this.postingStatusBOToPostingStatus(posting.getPstStatus()));
        postingLine.setHash(posting.getHash());
        postingLine.setDiscardedTime(posting.getDiscardedTime());
        return postingLine;
    }

    private String postingDetailsOpDetails(PostingLine postingLine) {
        if (postingLine == null) {
            return null;
        }
        OperationDetails details = postingLine.getDetails();
        if (details == null) {
            return null;
        }
        String opDetails = details.getOpDetails();
        if (opDetails == null) {
            return null;
        }
        return opDetails;
    }

    protected PostingTypeBO postingTypeToPostingTypeBO(PostingType postingType) {
        PostingTypeBO postingTypeBO;
        if (postingType == null) {
            return null;
        }
        switch (postingType) {
            case BUSI_TX: {
                postingTypeBO = PostingTypeBO.BUSI_TX;
                break;
            }
            case ADJ_TX: {
                postingTypeBO = PostingTypeBO.ADJ_TX;
                break;
            }
            case BAL_STMT: {
                postingTypeBO = PostingTypeBO.BAL_STMT;
                break;
            }
            case PnL_STMT: {
                postingTypeBO = PostingTypeBO.PnL_STMT;
                break;
            }
            case BS_STMT: {
                postingTypeBO = PostingTypeBO.BS_STMT;
                break;
            }
            case LDG_CLSNG: {
                postingTypeBO = PostingTypeBO.LDG_CLSNG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + postingType);
            }
        }
        return postingTypeBO;
    }

    protected PostingStatusBO postingStatusToPostingStatusBO(PostingStatus postingStatus) {
        PostingStatusBO postingStatusBO;
        if (postingStatus == null) {
            return null;
        }
        switch (postingStatus) {
            case DEFERRED: {
                postingStatusBO = PostingStatusBO.DEFERRED;
                break;
            }
            case POSTED: {
                postingStatusBO = PostingStatusBO.POSTED;
                break;
            }
            case PROPOSED: {
                postingStatusBO = PostingStatusBO.PROPOSED;
                break;
            }
            case SIMULATED: {
                postingStatusBO = PostingStatusBO.SIMULATED;
                break;
            }
            case TAX: {
                postingStatusBO = PostingStatusBO.TAX;
                break;
            }
            case UNPOSTED: {
                postingStatusBO = PostingStatusBO.UNPOSTED;
                break;
            }
            case CANCELLED: {
                postingStatusBO = PostingStatusBO.CANCELLED;
                break;
            }
            case OTHER: {
                postingStatusBO = PostingStatusBO.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + postingStatus);
            }
        }
        return postingStatusBO;
    }

    protected PostingType postingTypeBOToPostingType(PostingTypeBO postingTypeBO) {
        PostingType postingType;
        if (postingTypeBO == null) {
            return null;
        }
        switch (postingTypeBO) {
            case BUSI_TX: {
                postingType = PostingType.BUSI_TX;
                break;
            }
            case ADJ_TX: {
                postingType = PostingType.ADJ_TX;
                break;
            }
            case BAL_STMT: {
                postingType = PostingType.BAL_STMT;
                break;
            }
            case PnL_STMT: {
                postingType = PostingType.PnL_STMT;
                break;
            }
            case BS_STMT: {
                postingType = PostingType.BS_STMT;
                break;
            }
            case LDG_CLSNG: {
                postingType = PostingType.LDG_CLSNG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + postingTypeBO);
            }
        }
        return postingType;
    }

    protected PostingStatus postingStatusBOToPostingStatus(PostingStatusBO postingStatusBO) {
        PostingStatus postingStatus;
        if (postingStatusBO == null) {
            return null;
        }
        switch (postingStatusBO) {
            case DEFERRED: {
                postingStatus = PostingStatus.DEFERRED;
                break;
            }
            case POSTED: {
                postingStatus = PostingStatus.POSTED;
                break;
            }
            case PROPOSED: {
                postingStatus = PostingStatus.PROPOSED;
                break;
            }
            case SIMULATED: {
                postingStatus = PostingStatus.SIMULATED;
                break;
            }
            case TAX: {
                postingStatus = PostingStatus.TAX;
                break;
            }
            case UNPOSTED: {
                postingStatus = PostingStatus.UNPOSTED;
                break;
            }
            case CANCELLED: {
                postingStatus = PostingStatus.CANCELLED;
                break;
            }
            case OTHER: {
                postingStatus = PostingStatus.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + postingStatusBO);
            }
        }
        return postingStatus;
    }
}

