/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.converter;

import de.adorsys.ledgers.postings.api.domain.PostingBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.postings.api.domain.PostingStatusBO;
import de.adorsys.ledgers.postings.api.domain.PostingTypeBO;
import de.adorsys.ledgers.postings.db.domain.OperationDetails;
import de.adorsys.ledgers.postings.db.domain.Posting;
import de.adorsys.ledgers.postings.db.domain.PostingLine;
import de.adorsys.ledgers.postings.db.domain.PostingStatus;
import de.adorsys.ledgers.postings.db.domain.PostingType;
import de.adorsys.ledgers.postings.impl.converter.LedgerAccountMapper;
import de.adorsys.ledgers.postings.impl.converter.LedgerMapper;
import de.adorsys.ledgers.postings.impl.converter.PostingMapper;
import de.adorsys.ledgers.util.Ids;
import java.util.ArrayList;
import java.util.List;
import org.mapstruct.factory.Mappers;

public class PostingMapperImpl
implements PostingMapper {
    private final LedgerAccountMapper ledgerAccountMapper = (LedgerAccountMapper)Mappers.getMapper(LedgerAccountMapper.class);
    private final LedgerMapper ledgerMapper = (LedgerMapper)Mappers.getMapper(LedgerMapper.class);

    @Override
    public PostingBO toPostingBO(Posting posting) {
        if (posting == null) {
            return null;
        }
        PostingBO postingBO = new PostingBO();
        postingBO.setOprDetails(this.postingOprDetailsOpDetails(posting));
        postingBO.setAntecedentId(posting.getAntecedentId());
        postingBO.setAntecedentHash(posting.getAntecedentHash());
        postingBO.setHash(posting.getHash());
        postingBO.setHashAlg(posting.getHashAlg());
        postingBO.setId(posting.getId());
        postingBO.setRecordUser(posting.getRecordUser());
        postingBO.setRecordTime(posting.getRecordTime());
        postingBO.setOprId(posting.getOprId());
        postingBO.setOprTime(posting.getOprTime());
        postingBO.setOprType(posting.getOprType());
        postingBO.setOprSrc(posting.getOprSrc());
        postingBO.setPstTime(posting.getPstTime());
        postingBO.setPstType(this.postingTypeToPostingTypeBO(posting.getPstType()));
        postingBO.setPstStatus(this.postingStatusToPostingStatusBO(posting.getPstStatus()));
        postingBO.setLedger(this.ledgerMapper.toLedgerBO(posting.getLedger()));
        postingBO.setValTime(posting.getValTime());
        postingBO.setLines(this.postingLineListToPostingLineBOList(posting.getLines()));
        postingBO.setDiscardedId(posting.getDiscardedId());
        postingBO.setDiscardedTime(posting.getDiscardedTime());
        postingBO.setDiscardingId(posting.getDiscardingId());
        return postingBO;
    }

    @Override
    public Posting toPosting(PostingBO posting) {
        if (posting == null) {
            return null;
        }
        Posting posting1 = new Posting();
        posting1.setAntecedentId(posting.getAntecedentId());
        posting1.setAntecedentHash(posting.getAntecedentHash());
        posting1.setHash(posting.getHash());
        posting1.setHashAlg(posting.getHashAlg());
        posting1.setId(posting.getId());
        posting1.setRecordUser(posting.getRecordUser());
        posting1.setRecordTime(posting.getRecordTime());
        posting1.setOprId(posting.getOprId());
        posting1.setOprTime(posting.getOprTime());
        posting1.setOprType(posting.getOprType());
        posting1.setOprDetails(this.toOperationDetails(posting.getOprDetails()));
        posting1.setOprSrc(posting.getOprSrc());
        posting1.setPstTime(posting.getPstTime());
        posting1.setPstType(this.postingTypeBOToPostingType(posting.getPstType()));
        posting1.setPstStatus(this.postingStatusBOToPostingStatus(posting.getPstStatus()));
        posting1.setLedger(this.ledgerMapper.toLedger(posting.getLedger()));
        posting1.setValTime(posting.getValTime());
        posting1.setLines(this.postingLineBOListToPostingLineList(posting.getLines()));
        posting1.setDiscardedId(posting.getDiscardedId());
        posting1.setDiscardedTime(posting.getDiscardedTime());
        posting1.setDiscardingId(posting.getDiscardingId());
        return posting1;
    }

    @Override
    public String toOprDetailsBO(OperationDetails operationDetails) {
        if (operationDetails == null) {
            return null;
        }
        String string = new String();
        return string;
    }

    @Override
    public OperationDetails toOperationDetails(String operationDetails) {
        if (operationDetails == null) {
            return null;
        }
        OperationDetails operationDetails1 = new OperationDetails();
        operationDetails1.setOpDetails(operationDetails);
        operationDetails1.setId(Ids.id());
        return operationDetails1;
    }

    @Override
    public List<Posting> toPostingList(List<PostingBO> postingsBO) {
        if (postingsBO == null) {
            return null;
        }
        ArrayList<Posting> list = new ArrayList<Posting>(postingsBO.size());
        for (PostingBO postingBO : postingsBO) {
            list.add(this.toPosting(postingBO));
        }
        return list;
    }

    private String postingOprDetailsOpDetails(Posting posting) {
        if (posting == null) {
            return null;
        }
        OperationDetails oprDetails = posting.getOprDetails();
        if (oprDetails == null) {
            return null;
        }
        String opDetails = oprDetails.getOpDetails();
        if (opDetails == null) {
            return null;
        }
        return opDetails;
    }

    protected PostingTypeBO postingTypeToPostingTypeBO(PostingType postingType) {
        PostingTypeBO postingTypeBO;
        if (postingType == null) {
            return null;
        }
        switch (postingType) {
            case BUSI_TX: {
                postingTypeBO = PostingTypeBO.BUSI_TX;
                break;
            }
            case ADJ_TX: {
                postingTypeBO = PostingTypeBO.ADJ_TX;
                break;
            }
            case BAL_STMT: {
                postingTypeBO = PostingTypeBO.BAL_STMT;
                break;
            }
            case PnL_STMT: {
                postingTypeBO = PostingTypeBO.PnL_STMT;
                break;
            }
            case BS_STMT: {
                postingTypeBO = PostingTypeBO.BS_STMT;
                break;
            }
            case LDG_CLSNG: {
                postingTypeBO = PostingTypeBO.LDG_CLSNG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + postingType);
            }
        }
        return postingTypeBO;
    }

    protected PostingStatusBO postingStatusToPostingStatusBO(PostingStatus postingStatus) {
        PostingStatusBO postingStatusBO;
        if (postingStatus == null) {
            return null;
        }
        switch (postingStatus) {
            case DEFERRED: {
                postingStatusBO = PostingStatusBO.DEFERRED;
                break;
            }
            case POSTED: {
                postingStatusBO = PostingStatusBO.POSTED;
                break;
            }
            case PROPOSED: {
                postingStatusBO = PostingStatusBO.PROPOSED;
                break;
            }
            case SIMULATED: {
                postingStatusBO = PostingStatusBO.SIMULATED;
                break;
            }
            case TAX: {
                postingStatusBO = PostingStatusBO.TAX;
                break;
            }
            case UNPOSTED: {
                postingStatusBO = PostingStatusBO.UNPOSTED;
                break;
            }
            case CANCELLED: {
                postingStatusBO = PostingStatusBO.CANCELLED;
                break;
            }
            case OTHER: {
                postingStatusBO = PostingStatusBO.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + postingStatus);
            }
        }
        return postingStatusBO;
    }

    protected PostingLineBO postingLineToPostingLineBO(PostingLine postingLine) {
        if (postingLine == null) {
            return null;
        }
        PostingLineBO postingLineBO = new PostingLineBO();
        postingLineBO.setId(postingLine.getId());
        postingLineBO.setAccount(this.ledgerAccountMapper.toLedgerAccountBO(postingLine.getAccount()));
        postingLineBO.setDebitAmount(postingLine.getDebitAmount());
        postingLineBO.setCreditAmount(postingLine.getCreditAmount());
        postingLineBO.setDetails(this.toOprDetailsBO(postingLine.getDetails()));
        postingLineBO.setSrcAccount(postingLine.getSrcAccount());
        postingLineBO.setBaseLine(postingLine.getBaseLine());
        postingLineBO.setSubOprSrcId(postingLine.getSubOprSrcId());
        postingLineBO.setRecordTime(postingLine.getRecordTime());
        postingLineBO.setOprId(postingLine.getOprId());
        postingLineBO.setOprSrc(postingLine.getOprSrc());
        postingLineBO.setPstTime(postingLine.getPstTime());
        postingLineBO.setPstType(this.postingTypeToPostingTypeBO(postingLine.getPstType()));
        postingLineBO.setPstStatus(this.postingStatusToPostingStatusBO(postingLine.getPstStatus()));
        postingLineBO.setHash(postingLine.getHash());
        postingLineBO.setDiscardedTime(postingLine.getDiscardedTime());
        return postingLineBO;
    }

    protected List<PostingLineBO> postingLineListToPostingLineBOList(List<PostingLine> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PostingLineBO> list1 = new ArrayList<PostingLineBO>(list.size());
        for (PostingLine postingLine : list) {
            list1.add(this.postingLineToPostingLineBO(postingLine));
        }
        return list1;
    }

    protected PostingType postingTypeBOToPostingType(PostingTypeBO postingTypeBO) {
        PostingType postingType;
        if (postingTypeBO == null) {
            return null;
        }
        switch (postingTypeBO) {
            case BUSI_TX: {
                postingType = PostingType.BUSI_TX;
                break;
            }
            case ADJ_TX: {
                postingType = PostingType.ADJ_TX;
                break;
            }
            case BAL_STMT: {
                postingType = PostingType.BAL_STMT;
                break;
            }
            case PnL_STMT: {
                postingType = PostingType.PnL_STMT;
                break;
            }
            case BS_STMT: {
                postingType = PostingType.BS_STMT;
                break;
            }
            case LDG_CLSNG: {
                postingType = PostingType.LDG_CLSNG;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + postingTypeBO);
            }
        }
        return postingType;
    }

    protected PostingStatus postingStatusBOToPostingStatus(PostingStatusBO postingStatusBO) {
        PostingStatus postingStatus;
        if (postingStatusBO == null) {
            return null;
        }
        switch (postingStatusBO) {
            case DEFERRED: {
                postingStatus = PostingStatus.DEFERRED;
                break;
            }
            case POSTED: {
                postingStatus = PostingStatus.POSTED;
                break;
            }
            case PROPOSED: {
                postingStatus = PostingStatus.PROPOSED;
                break;
            }
            case SIMULATED: {
                postingStatus = PostingStatus.SIMULATED;
                break;
            }
            case TAX: {
                postingStatus = PostingStatus.TAX;
                break;
            }
            case UNPOSTED: {
                postingStatus = PostingStatus.UNPOSTED;
                break;
            }
            case CANCELLED: {
                postingStatus = PostingStatus.CANCELLED;
                break;
            }
            case OTHER: {
                postingStatus = PostingStatus.OTHER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + postingStatusBO);
            }
        }
        return postingStatus;
    }

    protected PostingLine postingLineBOToPostingLine(PostingLineBO postingLineBO) {
        if (postingLineBO == null) {
            return null;
        }
        PostingLine postingLine = new PostingLine();
        postingLine.setId(postingLineBO.getId());
        postingLine.setAccount(this.ledgerAccountMapper.toLedgerAccount(postingLineBO.getAccount()));
        postingLine.setDebitAmount(postingLineBO.getDebitAmount());
        postingLine.setCreditAmount(postingLineBO.getCreditAmount());
        postingLine.setDetails(this.toOperationDetails(postingLineBO.getDetails()));
        postingLine.setSrcAccount(postingLineBO.getSrcAccount());
        postingLine.setBaseLine(postingLineBO.getBaseLine());
        postingLine.setSubOprSrcId(postingLineBO.getSubOprSrcId());
        postingLine.setRecordTime(postingLineBO.getRecordTime());
        postingLine.setOprId(postingLineBO.getOprId());
        postingLine.setOprSrc(postingLineBO.getOprSrc());
        postingLine.setPstTime(postingLineBO.getPstTime());
        postingLine.setPstType(this.postingTypeBOToPostingType(postingLineBO.getPstType()));
        postingLine.setPstStatus(this.postingStatusBOToPostingStatus(postingLineBO.getPstStatus()));
        postingLine.setHash(postingLineBO.getHash());
        postingLine.setDiscardedTime(postingLineBO.getDiscardedTime());
        return postingLine;
    }

    protected List<PostingLine> postingLineBOListToPostingLineList(List<PostingLineBO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PostingLine> list1 = new ArrayList<PostingLine>(list.size());
        for (PostingLineBO postingLineBO : list) {
            list1.add(this.postingLineBOToPostingLine(postingLineBO));
        }
        return list1;
    }
}

