/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.service;

import de.adorsys.ledgers.postings.api.domain.ChartOfAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.db.domain.ChartOfAccount;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.repository.ChartOfAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerRepository;
import de.adorsys.ledgers.postings.impl.converter.LedgerAccountMapper;
import de.adorsys.ledgers.util.exception.PostingErrorCode;
import de.adorsys.ledgers.util.exception.PostingModuleException;
import org.mapstruct.factory.Mappers;

public class AbstractServiceImpl {
    private static final String COA_NF_BY_ID_MSG = "Chart of Account with id: %s not found!";
    private static final String COA_NF_BY_NAME_MSG = "Chart of Account with name: %s not found!";
    private static final String LA_NF_BY_ID_MSG = "Ledger Account with id: %s not found!";
    protected static final String LA_NF_BY_NAME_MSG = "Ledger Account with Ledger name : %s not found!";
    private static final String LEDGER_NF_BY_ID_MSG = "Ledger with id: %s not found!";
    private static final String LEDGER_NF_BY_NAME_MSG = "Ledger with Ledger name : %s not found!";
    protected final LedgerAccountRepository ledgerAccountRepository;
    protected final ChartOfAccountRepository chartOfAccountRepo;
    protected final LedgerRepository ledgerRepository;
    protected final LedgerAccountMapper ledgerAccountMapper = (LedgerAccountMapper)Mappers.getMapper(LedgerAccountMapper.class);

    protected ChartOfAccount loadCoa(ChartOfAccountBO chartOfAccountBO) {
        if (chartOfAccountBO == null) {
            throw this.nullInfo();
        }
        if (chartOfAccountBO.getId() != null) {
            return (ChartOfAccount)this.chartOfAccountRepo.findById((Object)chartOfAccountBO.getId()).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.CHART_OF_ACCOUNT_NOT_FOUND).devMsg(String.format(COA_NF_BY_ID_MSG, chartOfAccountBO.getId())).build());
        }
        if (chartOfAccountBO.getName() != null) {
            return (ChartOfAccount)this.chartOfAccountRepo.findOptionalByName(chartOfAccountBO.getName()).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.CHART_OF_ACCOUNT_NOT_FOUND).devMsg(String.format(COA_NF_BY_NAME_MSG, chartOfAccountBO.getName())).build());
        }
        throw this.insufficientInfo(chartOfAccountBO);
    }

    protected LedgerAccount loadLedgerAccountBO(LedgerAccountBO ledgerAccountBO) {
        LedgerAccount ledgerAccount = this.ledgerAccountMapper.toLedgerAccount(ledgerAccountBO);
        return this.loadLedgerAccount(ledgerAccount);
    }

    protected LedgerAccount loadLedgerAccount(LedgerAccount ledgerAccount) {
        if (ledgerAccount == null) {
            throw this.nullInfo();
        }
        if (ledgerAccount.getId() != null) {
            return (LedgerAccount)this.ledgerAccountRepository.findById((Object)ledgerAccount.getId()).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.LEDGER_ACCOUNT_NOT_FOUND).devMsg(String.format(LA_NF_BY_ID_MSG, ledgerAccount.getId())).build());
        }
        if (ledgerAccount.getLedger() != null && ledgerAccount.getName() != null) {
            Ledger loadedLedger = this.loadLedger(ledgerAccount.getLedger());
            return (LedgerAccount)this.ledgerAccountRepository.findOptionalByLedgerAndName(loadedLedger, ledgerAccount.getName()).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.LEDGER_ACCOUNT_NOT_FOUND).devMsg(String.format(LA_NF_BY_NAME_MSG, ledgerAccount.getName())).build());
        }
        throw this.insufficientInfo(ledgerAccount);
    }

    protected Ledger loadLedger(LedgerBO ledgerBO) {
        if (ledgerBO == null) {
            throw this.nullInfo();
        }
        return this.loadLedgerByIdOrName(ledgerBO.getId(), ledgerBO.getName());
    }

    protected Ledger loadLedger(Ledger ledger) {
        if (ledger == null) {
            throw this.nullInfo();
        }
        return this.loadLedgerByIdOrName(ledger.getId(), ledger.getName());
    }

    private Ledger loadLedgerByIdOrName(String id, String name) {
        if (id != null) {
            return (Ledger)this.ledgerRepository.findById((Object)id).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.LEDGER_NOT_FOUND).devMsg(String.format(LEDGER_NF_BY_ID_MSG, id)).build());
        }
        if (name != null) {
            return (Ledger)this.ledgerRepository.findOptionalByName(name).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.LEDGER_NOT_FOUND).devMsg(String.format(LEDGER_NF_BY_NAME_MSG, name)).build());
        }
        throw this.insufficientInfo("Both id and name fields are NULL!");
    }

    private PostingModuleException insufficientInfo(Object modelObject) {
        return PostingModuleException.builder().errorCode(PostingErrorCode.NOT_ENOUGH_INFO).devMsg(String.format("Model Object does not provide sufficient information for loading original instance. %s", modelObject.toString())).build();
    }

    private PostingModuleException nullInfo() {
        return PostingModuleException.builder().errorCode(PostingErrorCode.NOT_ENOUGH_INFO).devMsg("Model object can not be null").build();
    }

    public AbstractServiceImpl(LedgerAccountRepository ledgerAccountRepository, ChartOfAccountRepository chartOfAccountRepo, LedgerRepository ledgerRepository) {
        this.ledgerAccountRepository = ledgerAccountRepository;
        this.chartOfAccountRepo = chartOfAccountRepo;
        this.ledgerRepository = ledgerRepository;
    }
}

