/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.service;

import de.adorsys.ledgers.postings.api.domain.AccountStmtBO;
import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.service.AccountStmtService;
import de.adorsys.ledgers.postings.db.domain.AccountStmt;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.domain.PostingLine;
import de.adorsys.ledgers.postings.db.domain.PostingTrace;
import de.adorsys.ledgers.postings.db.domain.StmtStatus;
import de.adorsys.ledgers.postings.db.repository.AccountStmtRepository;
import de.adorsys.ledgers.postings.db.repository.ChartOfAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerRepository;
import de.adorsys.ledgers.postings.db.repository.PostingLineRepository;
import de.adorsys.ledgers.postings.impl.converter.AccountStmtMapper;
import de.adorsys.ledgers.postings.impl.service.AbstractServiceImpl;
import de.adorsys.ledgers.util.Ids;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import org.mapstruct.factory.Mappers;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountStmtServiceImpl
extends AbstractServiceImpl
implements AccountStmtService {
    private AccountStmtRepository accountStmtRepository;
    private PostingLineRepository postingLineRepository;
    private AccountStmtMapper accountStmtMapper = (AccountStmtMapper)Mappers.getMapper(AccountStmtMapper.class);

    public AccountStmtServiceImpl(LedgerAccountRepository ledgerAccountRepository, ChartOfAccountRepository chartOfAccountRepo, LedgerRepository ledgerRepository, AccountStmtRepository accountStmtRepository, PostingLineRepository postingLineRepository) {
        super(ledgerAccountRepository, chartOfAccountRepo, ledgerRepository);
        this.accountStmtRepository = accountStmtRepository;
        this.postingLineRepository = postingLineRepository;
    }

    @Transactional(readOnly=true)
    public AccountStmtBO readStmt(LedgerAccountBO ledgerAccount, LocalDateTime refTime) {
        AccountStmt stmt = this.stmt(ledgerAccount, refTime);
        return this.accountStmtMapper.toAccountStmtBO(stmt);
    }

    public AccountStmtBO createStmt(LedgerAccountBO ledgerAccount, LocalDateTime refTime) {
        AccountStmt stmt = this.stmt(ledgerAccount, refTime);
        stmt = (AccountStmt)this.accountStmtRepository.save((Object)stmt);
        return this.accountStmtMapper.toAccountStmtBO(stmt);
    }

    public AccountStmtBO closeStmt(AccountStmtBO stmt) {
        return null;
    }

    private AccountStmt stmt(LedgerAccountBO ledgerAccount, LocalDateTime refTime) {
        LedgerAccount account = this.loadLedgerAccountBO(ledgerAccount);
        AccountStmt accStmt = this.accountStmtRepository.findFirstByAccountAndStmtStatusAndPstTimeLessThanOrderByPstTimeDescStmtSeqNbrDesc(account, StmtStatus.CLOSED, refTime).orElseGet(() -> this.newStmtObj(refTime, account));
        List postingLines = accStmt.getPosting() == null ? this.postingLineRepository.findByAccountAndPstTimeLessThanEqualAndDiscardedTimeIsNullOrderByRecordTimeDesc(account, refTime) : this.postingLineRepository.findByBaseLineAndPstTimeLessThanEqualAndDiscardedTimeIsNullOrderByRecordTimeDesc(accStmt.getId(), refTime);
        return this.computeBalance(accStmt, postingLines);
    }

    private AccountStmt newStmtObj(LocalDateTime refTime, LedgerAccount account) {
        AccountStmt accStmt = new AccountStmt();
        accStmt.setId(Ids.id());
        accStmt.setAccount(account);
        accStmt.setPstTime(refTime);
        accStmt.setStmtSeqNbr(0);
        accStmt.setStmtStatus(StmtStatus.SIMULATED);
        accStmt.setTotalCredit(BigDecimal.ZERO);
        accStmt.setTotalDebit(BigDecimal.ZERO);
        return accStmt;
    }

    private AccountStmt computeBalance(AccountStmt stmt, List<PostingLine> lines) {
        if (!lines.isEmpty()) {
            for (PostingLine line : lines) {
                this.refreshStatement(stmt, line);
            }
        }
        return stmt;
    }

    private void refreshStatement(AccountStmt stmt, PostingLine line) {
        PostingTrace p = this.createPostingTrace(stmt, line);
        if (stmt.getYoungestPst() == null || stmt.getYoungestPst().getSrcPstTime().isBefore(p.getSrcPstTime())) {
            stmt.setYoungestPst(p);
        }
        stmt.setLatestPst(p);
        stmt.setTotalDebit(stmt.getTotalDebit().add(line.getDebitAmount()));
        stmt.setTotalCredit(stmt.getTotalCredit().add(line.getCreditAmount()));
    }

    private PostingTrace createPostingTrace(AccountStmt stmt, PostingLine line) {
        PostingTrace p = new PostingTrace();
        p.setAccount(stmt.getAccount());
        p.setCreditAmount(line.getCreditAmount());
        p.setDebitAmount(line.getDebitAmount());
        p.setId(Ids.id());
        p.setSrcOprId(line.getOprId());
        p.setSrcPstHash(line.getHash());
        p.setSrcPstTime(line.getPstTime());
        p.setTgtPstId(stmt.getId());
        return p;
    }
}

