/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.service;

import de.adorsys.ledgers.postings.api.domain.ChartOfAccountBO;
import de.adorsys.ledgers.postings.api.service.ChartOfAccountService;
import de.adorsys.ledgers.postings.db.domain.ChartOfAccount;
import de.adorsys.ledgers.postings.db.repository.ChartOfAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerRepository;
import de.adorsys.ledgers.postings.impl.converter.ChartOfAccountMapper;
import de.adorsys.ledgers.postings.impl.service.AbstractServiceImpl;
import de.adorsys.ledgers.util.Ids;
import java.time.LocalDateTime;
import java.util.Optional;
import org.mapstruct.factory.Mappers;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ChartOfAccountServiceImpl
extends AbstractServiceImpl
implements ChartOfAccountService {
    private final ChartOfAccountMapper chartOfAccountMapper = (ChartOfAccountMapper)Mappers.getMapper(ChartOfAccountMapper.class);

    public ChartOfAccountServiceImpl(LedgerAccountRepository ledgerAccountRepository, ChartOfAccountRepository chartOfAccountRepo, LedgerRepository ledgerRepository) {
        super(ledgerAccountRepository, chartOfAccountRepo, ledgerRepository);
    }

    public ChartOfAccountBO newChartOfAccount(ChartOfAccountBO coa) {
        LocalDateTime created = LocalDateTime.now();
        ChartOfAccount chartOfAccount = new ChartOfAccount(Ids.id(), created, coa.getUserDetails(), coa.getShortDesc(), coa.getLongDesc(), coa.getName());
        return this.chartOfAccountMapper.toChartOfAccountBO((ChartOfAccount)this.chartOfAccountRepo.save((Object)chartOfAccount));
    }

    public Optional<ChartOfAccountBO> findChartOfAccountsById(String id) {
        return this.chartOfAccountRepo.findById((Object)id).map(this.chartOfAccountMapper::toChartOfAccountBO);
    }

    public Optional<ChartOfAccountBO> findChartOfAccountsByName(String name) {
        return this.chartOfAccountRepo.findOptionalByName(name).map(this.chartOfAccountMapper::toChartOfAccountBO);
    }
}

