/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.service;

import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.LedgerBO;
import de.adorsys.ledgers.postings.api.domain.NamedBO;
import de.adorsys.ledgers.postings.api.service.LedgerService;
import de.adorsys.ledgers.postings.db.domain.AccountCategory;
import de.adorsys.ledgers.postings.db.domain.BalanceSide;
import de.adorsys.ledgers.postings.db.domain.ChartOfAccount;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.repository.ChartOfAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerRepository;
import de.adorsys.ledgers.postings.impl.converter.LedgerMapper;
import de.adorsys.ledgers.postings.impl.service.AbstractServiceImpl;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.ledgers.util.exception.PostingErrorCode;
import de.adorsys.ledgers.util.exception.PostingModuleException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.factory.Mappers;
import org.springframework.stereotype.Service;

@Service
public class LedgerServiceImpl
extends AbstractServiceImpl
implements LedgerService {
    private final LedgerMapper ledgerMapper = (LedgerMapper)Mappers.getMapper(LedgerMapper.class);

    public LedgerServiceImpl(LedgerAccountRepository ledgerAccountRepository, ChartOfAccountRepository chartOfAccountRepo, LedgerRepository ledgerRepository) {
        super(ledgerAccountRepository, chartOfAccountRepo, ledgerRepository);
    }

    public LedgerBO newLedger(LedgerBO ledger) {
        Ledger newLedger = new Ledger(Ids.id(), LocalDateTime.now(), ledger.getName(), ledger.getShortDesc(), ledger.getLongDesc(), ledger.getName(), this.loadCoa(ledger.getCoa()));
        Ledger savedLedger = (Ledger)this.ledgerRepository.save((Object)newLedger);
        return this.ledgerMapper.toLedgerBO(savedLedger);
    }

    public Optional<LedgerBO> findLedgerById(String id) {
        return this.ledgerRepository.findById((Object)id).map(this.ledgerMapper::toLedgerBO);
    }

    public Optional<LedgerBO> findLedgerByName(String name) {
        return this.ledgerRepository.findOptionalByName(name).map(this.ledgerMapper::toLedgerBO);
    }

    public LedgerAccountBO newLedgerAccount(LedgerAccountBO ledgerAccount, String userName) {
        if (StringUtils.isBlank((CharSequence)ledgerAccount.getName())) {
            throw PostingModuleException.builder().errorCode(PostingErrorCode.NOT_ENOUGH_INFO).devMsg("Missing model name.").build();
        }
        LedgerAccount parentAccount = this.getParentAccount(ledgerAccount);
        Ledger ledger = parentAccount != null ? parentAccount.getLedger() : this.loadLedger(ledgerAccount.getLedger());
        AccountCategory category = ledgerAccount.getCategory() != null ? AccountCategory.valueOf((String)ledgerAccount.getCategory().name()) : this.getAccountCategoryFromParent(parentAccount, ledgerAccount.getShortDesc());
        BalanceSide balanceSide = ledgerAccount.getBalanceSide() != null ? BalanceSide.valueOf((String)ledgerAccount.getBalanceSide().name()) : this.getBalanceSide(parentAccount, category, ledgerAccount.getShortDesc());
        String id = Ids.id();
        LocalDateTime created = LocalDateTime.now();
        String shortDesc = ledgerAccount.getShortDesc();
        String longDesc = ledgerAccount.getLongDesc();
        String name = ledgerAccount.getName();
        ChartOfAccount coa = ledger.getCoa();
        LedgerAccount newLedgerAccount = new LedgerAccount(id, created, userName, shortDesc, longDesc, name, ledger, parentAccount, coa, balanceSide, category);
        return this.ledgerAccountMapper.toLedgerAccountBO((LedgerAccount)this.ledgerAccountRepository.save((Object)newLedgerAccount));
    }

    public LedgerAccountBO findLedgerAccountById(String id) {
        return this.ledgerAccountRepository.findById((Object)id).map(this.ledgerAccountMapper::toLedgerAccountBO).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.LEDGER_ACCOUNT_NOT_FOUND).devMsg(String.format("Ledger Account with Ledger name : %s not found!", id)).build());
    }

    public LedgerAccountBO findLedgerAccount(LedgerBO ledgerBO, String name) {
        Ledger ledger = this.ledgerMapper.toLedger(ledgerBO);
        return this.ledgerAccountRepository.findOptionalByLedgerAndName(this.loadLedger(ledger), name).map(this.ledgerAccountMapper::toLedgerAccountBO).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.LEDGER_ACCOUNT_NOT_FOUND).devMsg(String.format("Ledger Account with Ledger name : %s not found!", name)).build());
    }

    public boolean checkIfLedgerAccountExist(LedgerBO ledgerBO, String name) {
        try {
            Ledger ledger = this.loadLedger(ledgerBO);
            return this.ledgerAccountRepository.findOptionalByLedgerAndName(ledger, name).isPresent();
        }
        catch (PostingModuleException e) {
            return false;
        }
    }

    public Map<String, LedgerAccountBO> finLedgerAccountsByIbans(Set<String> ibans, LedgerBO ledgerBO) {
        Ledger ledger = this.loadLedger(ledgerBO);
        return this.ledgerAccountMapper.toLedgerAccountsBO(this.ledgerAccountRepository.getAccountsByIbans(ibans, ledger)).stream().collect(Collectors.toMap(NamedBO::getName, Function.identity()));
    }

    private LedgerAccount getParentAccount(LedgerAccountBO ledgerAccount) {
        return ledgerAccount.getParent() != null ? this.loadLedgerAccountBO(ledgerAccount.getParent()) : null;
    }

    private BalanceSide getBalanceSide(LedgerAccount parentAccount, AccountCategory category, String shortDesc) {
        BalanceSide balanceSide;
        if (parentAccount != null) {
            balanceSide = parentAccount.getBalanceSide();
        } else if (category != null) {
            balanceSide = category.getDefaultBs();
        } else {
            throw this.getNoCategoryException(shortDesc);
        }
        return balanceSide;
    }

    private AccountCategory getAccountCategoryFromParent(LedgerAccount parentAccount, String shortDescription) {
        return Optional.ofNullable(parentAccount).map(LedgerAccount::getCategory).orElseThrow(() -> this.getNoCategoryException(shortDescription));
    }

    private PostingModuleException getNoCategoryException(String variable) {
        return PostingModuleException.builder().errorCode(PostingErrorCode.NO_CATEGORY).devMsg(String.format("Missing category for: %s", variable)).build();
    }
}

