/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.postings.impl.service;

import de.adorsys.ledgers.postings.api.domain.LedgerAccountBO;
import de.adorsys.ledgers.postings.api.domain.PostingBO;
import de.adorsys.ledgers.postings.api.domain.PostingLineBO;
import de.adorsys.ledgers.postings.api.service.PostingService;
import de.adorsys.ledgers.postings.db.domain.AccountStmt;
import de.adorsys.ledgers.postings.db.domain.Ledger;
import de.adorsys.ledgers.postings.db.domain.LedgerAccount;
import de.adorsys.ledgers.postings.db.domain.Posting;
import de.adorsys.ledgers.postings.db.domain.PostingLine;
import de.adorsys.ledgers.postings.db.domain.StmtStatus;
import de.adorsys.ledgers.postings.db.repository.AccountStmtRepository;
import de.adorsys.ledgers.postings.db.repository.ChartOfAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerAccountRepository;
import de.adorsys.ledgers.postings.db.repository.LedgerRepository;
import de.adorsys.ledgers.postings.db.repository.PostingLineRepository;
import de.adorsys.ledgers.postings.db.repository.PostingRepository;
import de.adorsys.ledgers.postings.impl.converter.PostingLineMapper;
import de.adorsys.ledgers.postings.impl.converter.PostingMapper;
import de.adorsys.ledgers.postings.impl.service.AbstractServiceImpl;
import de.adorsys.ledgers.util.CloneUtils;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.ledgers.util.exception.PostingErrorCode;
import de.adorsys.ledgers.util.exception.PostingModuleException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PostingServiceImpl
extends AbstractServiceImpl
implements PostingService {
    private static final Logger log = LoggerFactory.getLogger(PostingServiceImpl.class);
    private static final String DOBLE_ENTRY_ERROR_MSG = "Debit sums up to %s while credit sums up to %s";
    private static final String POSTING_NF_MSG = "Posting with account id %s  and transaction id %s could not be found";
    private static final String BASE_LINE_TIME_ERROR_MSG = "posting time %s is before the last ledger closing %s";
    private final PostingRepository postingRepository;
    private final AccountStmtRepository accountStmtRepository;
    private final PostingLineRepository postingLineRepository;
    private final PostingMapper postingMapper = (PostingMapper)Mappers.getMapper(PostingMapper.class);
    private final PostingLineMapper postingLineMapper = (PostingLineMapper)Mappers.getMapper(PostingLineMapper.class);

    public PostingServiceImpl(LedgerAccountRepository ledgerAccountRepository, ChartOfAccountRepository chartOfAccountRepo, LedgerRepository ledgerRepository, PostingRepository postingRepository, AccountStmtRepository accountStmtRepository, PostingLineRepository postingLineRepository) {
        super(ledgerAccountRepository, chartOfAccountRepo, ledgerRepository);
        this.postingRepository = postingRepository;
        this.accountStmtRepository = accountStmtRepository;
        this.postingLineRepository = postingLineRepository;
    }

    public PostingBO newPosting(PostingBO postingBO) {
        Posting posting = this.postingMapper.toPosting(postingBO);
        posting = this.newPosting(posting);
        return this.postingMapper.toPostingBO(posting);
    }

    public List<PostingBO> findPostingsByOperationId(String oprId) {
        return CloneUtils.cloneList((List)this.postingRepository.findByOprId(oprId), PostingBO.class);
    }

    @Transactional(readOnly=true)
    public List<PostingLineBO> findPostingsByDates(LedgerAccountBO ledgerAccount, LocalDateTime timeFrom, LocalDateTime timeTo) {
        LedgerAccount account = this.loadLedgerAccountBO(ledgerAccount);
        return this.postingLineRepository.findByAccountAndPstTimeGreaterThanAndPstTimeLessThanEqualAndDiscardedTimeIsNullOrderByPstTimeDesc(account, timeFrom, timeTo).stream().map(this.postingLineMapper::toPostingLineBO).collect(Collectors.toList());
    }

    public Page<PostingLineBO> findPostingsByDatesPaged(LedgerAccountBO ledgerAccount, LocalDateTime dateFrom, LocalDateTime dateTo, Pageable pageable) {
        LedgerAccount account = this.loadLedgerAccountBO(ledgerAccount);
        return this.postingLineRepository.findPostingsByAccountAndDates(account, dateFrom, dateTo, pageable).map(this.postingLineMapper::toPostingLineBO);
    }

    public PostingLineBO findPostingLineById(LedgerAccountBO ledgerAccount, String transactionId) {
        LedgerAccount account = this.loadLedgerAccountBO(ledgerAccount);
        return this.postingLineRepository.findFirstByIdAndAccount(transactionId, account).map(this.postingLineMapper::toPostingLineBO).orElseThrow(() -> PostingModuleException.builder().errorCode(PostingErrorCode.POSTING_NOT_FOUND).devMsg(String.format(POSTING_NF_MSG, account.getId(), transactionId)).build());
    }

    private Posting newPosting(Posting posting) {
        LocalDateTime now = LocalDateTime.now();
        Posting p = this.createPostingObj(posting, now);
        Ledger ledger = this.loadLedger(posting.getLedger());
        p.setLedger(ledger);
        this.loadPredecessor(p).ifPresent(discarded -> this.discardPosting((Posting)discarded, p));
        this.validateDoubleEntryAccounting(posting);
        Posting antecedent = this.postingRepository.findFirstByLedgerOrderByRecordTimeDesc(posting.getLedger()).orElse(new Posting());
        p.setAntecedentHash(antecedent.getHash());
        p.setAntecedentId(antecedent.getId());
        for (PostingLine pl : posting.getLines()) {
            this.processPostingLine(p, pl);
        }
        p.hash();
        p.synchLines();
        return (Posting)this.postingRepository.save((Object)p);
    }

    private Posting createPostingObj(Posting posting, LocalDateTime now) {
        Posting p = new Posting();
        p.setId(Ids.id());
        p.setOprDetails(posting.getOprDetails());
        p.setOprId(posting.getOprId());
        p.setOprSrc(posting.getOprSrc());
        p.setOprTime(posting.getOprTime());
        p.setOprType(posting.getOprType());
        p.setPstStatus(posting.getPstStatus());
        p.setPstTime(posting.getPstTime());
        p.setPstType(posting.getPstType());
        p.setRecordTime(now);
        p.setRecordUser(posting.getRecordUser());
        p.setValTime(posting.getValTime());
        return p;
    }

    private void discardPosting(Posting discarded, Posting discarding) {
        discarded.setDiscardedTime(discarding.getRecordTime());
        discarded.setDiscardingId(discarding.getId());
        discarded.synchLines();
        this.postingRepository.save((Object)discarded);
        discarding.setDiscardedId(discarded.getId());
    }

    private void processPostingLine(Posting p, PostingLine postingLine) {
        PostingLine l = new PostingLine();
        l.setId(postingLine.getId());
        LedgerAccount account = this.loadLedgerAccount(postingLine.getAccount());
        l.setAccount(account);
        String baseLine = this.validatePostingTime(p, account).orElse(new AccountStmt()).getId();
        l.setBaseLine(baseLine);
        l.setCreditAmount(postingLine.getCreditAmount());
        l.setDebitAmount(postingLine.getDebitAmount());
        l.setDetails(postingLine.getDetails());
        l.setSrcAccount(postingLine.getSrcAccount());
        l.setSubOprSrcId(postingLine.getSubOprSrcId());
        p.getLines().add(l);
    }

    private void validateDoubleEntryAccounting(Posting posting) {
        List lines = posting.getLines();
        BigDecimal sumDebit = BigDecimal.ZERO;
        BigDecimal sumCredit = BigDecimal.ZERO;
        for (PostingLine line : lines) {
            sumDebit = sumDebit.add(line.getDebitAmount());
            sumCredit = sumCredit.add(line.getCreditAmount());
        }
        if (!sumDebit.equals(sumCredit)) {
            log.error(String.format(DOBLE_ENTRY_ERROR_MSG, sumDebit, sumCredit));
            throw PostingModuleException.builder().errorCode(PostingErrorCode.DOBLE_ENTRY_ERROR).devMsg(String.format(DOBLE_ENTRY_ERROR_MSG, sumDebit, sumCredit)).build();
        }
    }

    private Optional<AccountStmt> validatePostingTime(Posting posting, LedgerAccount ledgerAccount) {
        this.postingTimeNotNull(posting);
        Optional stmtOpt = this.accountStmtRepository.findFirstByAccountAndStmtStatusAndPstTimeGreaterThanEqual(ledgerAccount, StmtStatus.CLOSED, posting.getPstTime());
        if (stmtOpt.isPresent()) {
            throw PostingModuleException.builder().errorCode(PostingErrorCode.BASE_LINE_TIME_ERROR).devMsg(String.format(BASE_LINE_TIME_ERROR_MSG, posting.getPstTime(), ((AccountStmt)stmtOpt.get()).getPstTime())).build();
        }
        return this.accountStmtRepository.findFirstByAccountAndStmtStatusAndPstTimeLessThanOrderByPstTimeDescStmtSeqNbrDesc(ledgerAccount, StmtStatus.CLOSED, posting.getPstTime());
    }

    private void postingTimeNotNull(Posting posting) {
        if (posting.getPstTime() == null) {
            throw PostingModuleException.builder().errorCode(PostingErrorCode.POSTING_TIME_MISSING).devMsg("Missing posting time").build();
        }
    }

    private Optional<Posting> loadPredecessor(Posting current) {
        return this.postingRepository.findByOprIdAndDiscardingIdIsNull(current.getOprId());
    }
}

