/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.config.rest;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AspspRemoteUrls {
    @Value(value="${mockspi.baseurl:http://localhost:28080}")
    private String spiMockBaseUrl;

    public String getAccountDetailsById() {
        return this.spiMockBaseUrl + "/account/{account-id}";
    }

    public String getBalancesByAccountId() {
        return this.spiMockBaseUrl + "/account/{account-id}/balances";
    }

    public String getAccountDetailsByPsuId() {
        return this.spiMockBaseUrl + "/account/psu/{psu-id}";
    }

    public String getAccountDetailsByIban() {
        return this.spiMockBaseUrl + "/account/iban/{iban}";
    }

    public String createPayment() {
        return this.spiMockBaseUrl + "/payments/";
    }

    public String getPaymentStatus() {
        return this.spiMockBaseUrl + "/payments/{payment-id}/status";
    }

    public String createBulkPayment() {
        return this.spiMockBaseUrl + "/payments/bulk-payments";
    }

    public String createPeriodicPayment() {
        return this.spiMockBaseUrl + "/payments/create-periodic-payment";
    }

    public String readTransactionById() {
        return this.spiMockBaseUrl + "/transaction/{transaction-id}/{account-id}";
    }

    public String readTransactionsByPeriod() {
        return this.spiMockBaseUrl + "/transaction/{account-id}";
    }

    public String createTransaction() {
        return this.spiMockBaseUrl + "/transaction";
    }

    public String getAllowedPaymentProducts() {
        return this.spiMockBaseUrl + "/psu/allowed-payment-products/{iban}";
    }

    public String getPaymentById() {
        return this.spiMockBaseUrl + "/payments/{payment-type}/{payment-product}/{paymentId}";
    }

    public String getScaMethods() {
        return this.spiMockBaseUrl + "/psu/sca-methods/{psuId}";
    }

    public String getGenerateTanConfirmation() {
        return this.spiMockBaseUrl + "/consent/confirmation/pis/{psuId}/{sca-method-selected}";
    }

    public String applyStrongUserAuthorisation() {
        return this.spiMockBaseUrl + "/consent/confirmation/pis";
    }

    public String getGenerateTanConfirmationForAis() {
        return this.spiMockBaseUrl + "/consent/confirmation/ais/{psuId}";
    }

    public String applyStrongUserAuthorisationForAis() {
        return this.spiMockBaseUrl + "/consent/confirmation/ais";
    }

    public String cancelPayment() {
        return this.spiMockBaseUrl + "/payments/{paymentId}";
    }

    public String initiatePaymentCancellation() {
        return this.spiMockBaseUrl + "/payments/{paymentId}/cancel";
    }
}

