/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.converter;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.BalanceTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.ExchangeRateTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountBalance;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountDetails;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiBalanceType;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiCardTransaction;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiExchangeRate;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiTransaction;
import de.adorsys.psd2.xs2a.spi.domain.common.SpiAmount;
import de.adorsys.psd2.xs2a.spi.domain.fund.SpiFundsConfirmationRequest;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class LedgersSpiAccountMapperImpl
extends LedgersSpiAccountMapper {
    @Override
    public List<SpiAccountDetails> toSpiAccountDetailsList(List<AccountDetailsTO> accountDetails) {
        if (accountDetails == null) {
            return null;
        }
        ArrayList<SpiAccountDetails> list = new ArrayList<SpiAccountDetails>(accountDetails.size());
        for (AccountDetailsTO accountDetailsTO : accountDetails) {
            list.add(this.toSpiAccountDetails(accountDetailsTO));
        }
        return list;
    }

    @Override
    public List<SpiTransaction> toSpiTransactions(List<TransactionTO> transactions) {
        if (transactions == null) {
            return null;
        }
        ArrayList<SpiTransaction> list = new ArrayList<SpiTransaction>(transactions.size());
        for (TransactionTO transactionTO : transactions) {
            list.add(this.toSpiTransaction(transactionTO));
        }
        return list;
    }

    @Override
    public List<SpiCardTransaction> toSpiCardTransactions(List<TransactionTO> transactions) {
        if (transactions == null) {
            return null;
        }
        ArrayList<SpiCardTransaction> list = new ArrayList<SpiCardTransaction>(transactions.size());
        for (TransactionTO transactionTO : transactions) {
            list.add(this.toSpiCardTransaction(transactionTO));
        }
        return list;
    }

    @Override
    public List<SpiAccountBalance> toSpiAccountBalancesList(List<AccountBalanceTO> accountBalanceTOS) {
        if (accountBalanceTOS == null) {
            return null;
        }
        ArrayList<SpiAccountBalance> list = new ArrayList<SpiAccountBalance>(accountBalanceTOS.size());
        for (AccountBalanceTO accountBalanceTO : accountBalanceTOS) {
            list.add(this.accountBalanceTOToSpiAccountBalance(accountBalanceTO));
        }
        return list;
    }

    @Override
    public SpiAccountBalance accountBalanceTOToSpiAccountBalance(AccountBalanceTO accountBalanceTO) {
        if (accountBalanceTO == null) {
            return null;
        }
        SpiAccountBalance spiAccountBalance = new SpiAccountBalance();
        spiAccountBalance.setSpiBalanceAmount(this.toSpiAmount(accountBalanceTO.getAmount()));
        spiAccountBalance.setSpiBalanceType(this.balanceTypeTOToSpiBalanceType(accountBalanceTO.getBalanceType()));
        spiAccountBalance.setLastChangeDateTime(accountBalanceTO.getLastChangeDateTime());
        spiAccountBalance.setReferenceDate(accountBalanceTO.getReferenceDate());
        spiAccountBalance.setLastCommittedTransaction(accountBalanceTO.getLastCommittedTransaction());
        return spiAccountBalance;
    }

    @Override
    public List<SpiExchangeRate> toSpiExchangeRateList(List<ExchangeRateTO> exchangeRates) {
        if (exchangeRates == null) {
            return null;
        }
        ArrayList<SpiExchangeRate> list = new ArrayList<SpiExchangeRate>(exchangeRates.size());
        for (ExchangeRateTO exchangeRateTO : exchangeRates) {
            list.add(this.toSpiExchangeRate(exchangeRateTO));
        }
        return list;
    }

    @Override
    public FundsConfirmationRequestTO toFundsConfirmationTO(SpiPsuData psuData, SpiFundsConfirmationRequest spiFundsConfirmationRequest) {
        if (psuData == null && spiFundsConfirmationRequest == null) {
            return null;
        }
        FundsConfirmationRequestTO fundsConfirmationRequestTO = new FundsConfirmationRequestTO();
        if (psuData != null) {
            fundsConfirmationRequestTO.setPsuId(psuData.getPsuId());
        }
        if (spiFundsConfirmationRequest != null) {
            fundsConfirmationRequestTO.setPsuAccount(this.mapToAccountReferenceTO(spiFundsConfirmationRequest.getPsuAccount()));
            fundsConfirmationRequestTO.setInstructedAmount(this.spiAmountToAmountTO(spiFundsConfirmationRequest.getInstructedAmount()));
            fundsConfirmationRequestTO.setCardNumber(spiFundsConfirmationRequest.getCardNumber());
            fundsConfirmationRequestTO.setPayee(spiFundsConfirmationRequest.getPayee());
        }
        return fundsConfirmationRequestTO;
    }

    @Override
    public AccountReferenceTO mapToAccountReferenceTO(SpiAccountReference spiAccountReference) {
        if (spiAccountReference == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(spiAccountReference.getIban());
        accountReferenceTO.setBban(spiAccountReference.getBban());
        accountReferenceTO.setPan(spiAccountReference.getPan());
        accountReferenceTO.setMaskedPan(spiAccountReference.getMaskedPan());
        accountReferenceTO.setMsisdn(spiAccountReference.getMsisdn());
        accountReferenceTO.setCurrency(spiAccountReference.getCurrency());
        return accountReferenceTO;
    }

    protected SpiBalanceType balanceTypeTOToSpiBalanceType(BalanceTypeTO balanceTypeTO) {
        SpiBalanceType spiBalanceType;
        if (balanceTypeTO == null) {
            return null;
        }
        switch (balanceTypeTO) {
            case CLOSING_BOOKED: {
                spiBalanceType = SpiBalanceType.CLOSING_BOOKED;
                break;
            }
            case EXPECTED: {
                spiBalanceType = SpiBalanceType.EXPECTED;
                break;
            }
            case AUTHORISED: {
                spiBalanceType = SpiBalanceType.AUTHORISED;
                break;
            }
            case OPENING_BOOKED: {
                spiBalanceType = SpiBalanceType.OPENING_BOOKED;
                break;
            }
            case INTERIM_AVAILABLE: {
                spiBalanceType = SpiBalanceType.INTERIM_AVAILABLE;
                break;
            }
            case FORWARD_AVAILABLE: {
                spiBalanceType = SpiBalanceType.FORWARD_AVAILABLE;
                break;
            }
            case NONINVOICED: {
                spiBalanceType = SpiBalanceType.NONINVOICED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + balanceTypeTO);
            }
        }
        return spiBalanceType;
    }

    protected AmountTO spiAmountToAmountTO(SpiAmount spiAmount) {
        if (spiAmount == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(spiAmount.getCurrency());
        amountTO.setAmount(spiAmount.getAmount());
        return amountTO;
    }
}

