/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiAccountMapper;
import de.adorsys.aspsp.xs2a.connector.spi.impl.MultilevelScaService;
import de.adorsys.ledgers.rest.client.UserMgmtRestClient;
import de.adorsys.psd2.xs2a.spi.domain.account.SpiAccountReference;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MultilevelScaServiceImpl
implements MultilevelScaService {
    private static final Logger log = LoggerFactory.getLogger(MultilevelScaServiceImpl.class);
    private final UserMgmtRestClient userMgmtRestClient;
    private final LedgersSpiAccountMapper ledgersSpiAccountMapper;

    @Override
    public boolean isMultilevelScaRequired(SpiPsuData spiPsuData, Set<SpiAccountReference> spiAccountReferences) {
        String psuId = spiPsuData.getPsuId();
        if (StringUtils.isBlank((CharSequence)psuId)) {
            return false;
        }
        List accountReferences = spiAccountReferences.stream().map(this.ledgersSpiAccountMapper::mapToAccountReferenceTO).collect(Collectors.toList());
        ResponseEntity response = this.userMgmtRestClient.multilevelAccounts(psuId, accountReferences);
        return BooleanUtils.toBoolean((Boolean)((Boolean)response.getBody()));
    }

    public MultilevelScaServiceImpl(UserMgmtRestClient userMgmtRestClient, LedgersSpiAccountMapper ledgersSpiAccountMapper) {
        this.userMgmtRestClient = userMgmtRestClient;
        this.ledgersSpiAccountMapper = ledgersSpiAccountMapper;
    }
}

