/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation;

import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaLoginMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.ScaMethodConverter;
import de.adorsys.aspsp.xs2a.connector.spi.impl.AspspConsentDataService;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionHandler;
import de.adorsys.aspsp.xs2a.connector.spi.impl.FeignExceptionReader;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.AbstractAuthorisationSpi;
import de.adorsys.aspsp.xs2a.connector.spi.impl.authorisation.GeneralAuthorisationService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import de.adorsys.ledgers.rest.client.AuthRequestInterceptor;
import de.adorsys.ledgers.rest.client.PaymentRestClient;
import de.adorsys.psd2.xs2a.core.error.MessageErrorCode;
import de.adorsys.psd2.xs2a.core.error.TppMessage;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiAuthorisationStatus;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiPsuAuthorisationResponse;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiScaConfirmation;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentCancellationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.PaymentCancellationSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import feign.FeignException;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class PaymentCancellationSpiImpl
extends AbstractAuthorisationSpi<SpiPayment, SCAPaymentResponseTO>
implements PaymentCancellationSpi {
    private static final Logger logger = LoggerFactory.getLogger(PaymentCancellationSpiImpl.class);
    private final PaymentRestClient paymentRestClient;
    private final TokenStorageService tokenStorageService;
    private final AuthRequestInterceptor authRequestInterceptor;
    private final AspspConsentDataService consentDataService;
    private final FeignExceptionReader feignExceptionReader;
    private final ScaLoginMapper scaLoginMapper;

    public PaymentCancellationSpiImpl(PaymentRestClient ledgersRestClient, TokenStorageService tokenStorageService, ScaMethodConverter scaMethodConverter, AuthRequestInterceptor authRequestInterceptor, AspspConsentDataService consentDataService, GeneralAuthorisationService authorisationService, FeignExceptionReader feignExceptionReader, ScaLoginMapper scaLoginMapper) {
        super(authRequestInterceptor, consentDataService, authorisationService, scaMethodConverter, feignExceptionReader, tokenStorageService);
        this.paymentRestClient = ledgersRestClient;
        this.tokenStorageService = tokenStorageService;
        this.authRequestInterceptor = authRequestInterceptor;
        this.consentDataService = consentDataService;
        this.feignExceptionReader = feignExceptionReader;
        this.scaLoginMapper = scaLoginMapper;
    }

    @NotNull
    public SpiResponse<SpiPaymentCancellationResponse> initiatePaymentCancellation(@NotNull SpiContextData contextData, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        SpiPaymentCancellationResponse response = new SpiPaymentCancellationResponse();
        boolean cancellationMandated = payment.getPaymentStatus() != TransactionStatus.RCVD;
        response.setCancellationAuthorisationMandated(cancellationMandated);
        response.setTransactionStatus(payment.getPaymentStatus());
        return SpiResponse.builder().payload((Object)response).build();
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> cancelPaymentWithoutSca(@NotNull SpiContextData contextData, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (payment.getPaymentStatus() == TransactionStatus.RCVD) {
            return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
        }
        SCAPaymentResponseTO sca = this.getSCAConsentResponse(aspspConsentDataProvider, true);
        if (sca.getScaStatus() == ScaStatusTO.EXEMPTED) {
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            try {
                this.paymentRestClient.initiatePmtCancellation(payment.getPaymentId());
                return SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build();
            }
            catch (FeignException feignException) {
                String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
                logger.error("Cancel payment without sca failed: payment ID {}, devMessage {}", (Object)payment.getPaymentId(), (Object)devMessage);
                return SpiResponse.builder().error(FeignExceptionHandler.getFailureMessage(feignException, MessageErrorCode.FORMAT_ERROR_CANCELLATION, devMessage)).build();
            }
        }
        return SpiResponse.builder().error(new TppMessage(MessageErrorCode.CANCELLATION_INVALID, new Object[0])).build();
    }

    @NotNull
    public SpiResponse<SpiResponse.VoidResponse> verifyScaAuthorisationAndCancelPayment(@NotNull SpiContextData contextData, @NotNull SpiScaConfirmation spiScaConfirmation, @NotNull SpiPayment payment, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider) {
        try {
            SCAPaymentResponseTO sca = this.getSCAConsentResponse(aspspConsentDataProvider, true);
            this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
            ResponseEntity response = this.paymentRestClient.authorizeCancelPayment(sca.getPaymentId(), sca.getAuthorisationId(), spiScaConfirmation.getTanNumber());
            return response.getStatusCode() == HttpStatus.OK ? SpiResponse.builder().payload((Object)SpiResponse.voidResponse()).build() : SpiResponse.builder().error(new TppMessage(MessageErrorCode.UNAUTHORIZED_CANCELLATION, new Object[0])).build();
        }
        catch (FeignException feignException) {
            String devMessage = this.feignExceptionReader.getErrorMessage(feignException);
            logger.error("Verify sca authorisation and cancel payment failed: payment ID {}, devMessage {}", (Object)payment.getPaymentId(), (Object)devMessage);
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.PSU_CREDENTIALS_INVALID, new Object[0])).build();
        }
    }

    @Override
    protected ResponseEntity<SCAPaymentResponseTO> getSelectMethodResponse(@NotNull String authenticationMethodId, SCAPaymentResponseTO sca) {
        return this.paymentRestClient.selecCancelPaymentSCAtMethod(sca.getPaymentId(), sca.getAuthorisationId(), authenticationMethodId);
    }

    @Override
    protected SCAPaymentResponseTO getSCAConsentResponse(@NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, boolean checkCredentials) {
        byte[] aspspConsentData = aspspConsentDataProvider.loadAspspConsentData();
        return this.consentDataService.response(aspspConsentData, SCAPaymentResponseTO.class, checkCredentials);
    }

    @Override
    protected String getBusinessObjectId(SpiPayment businessObject) {
        return businessObject.getPaymentId();
    }

    @Override
    protected OpTypeTO getOtpType() {
        return OpTypeTO.CANCEL_PAYMENT;
    }

    @Override
    protected TppMessage getAuthorisePsuFailureMessage(SpiPayment businessObject) {
        logger.error("Initiate single payment failed: payment ID {}", (Object)businessObject.getPaymentId());
        return new TppMessage(MessageErrorCode.PAYMENT_FAILED, new Object[0]);
    }

    @Override
    protected SpiResponse<SpiPsuAuthorisationResponse> onSuccessfulAuthorisation(SpiPayment businessObject, @NotNull SpiAspspConsentDataProvider aspspConsentDataProvider, SpiResponse<SpiPsuAuthorisationResponse> authorisePsu, SCAPaymentResponseTO scaBusinessObjectResponse) {
        try {
            aspspConsentDataProvider.updateAspspConsentData(this.tokenStorageService.toBytes((SCAResponseTO)scaBusinessObjectResponse));
            return SpiResponse.builder().payload((Object)new SpiPsuAuthorisationResponse(false, SpiAuthorisationStatus.SUCCESS)).build();
        }
        catch (IOException e) {
            return SpiResponse.builder().error(new TppMessage(MessageErrorCode.UNAUTHORIZED_CANCELLATION, new Object[0])).build();
        }
    }

    @Override
    protected SCAResponseTO initiateBusinessObject(SpiPayment businessObject, byte[] aspspConsentData) {
        return null;
    }

    @Override
    protected SCAPaymentResponseTO mapToScaResponse(SpiPayment businessObject, byte[] aspspConsentData, SCAPaymentResponseTO originalResponse) throws IOException {
        String paymentTypeString = Optional.ofNullable(businessObject.getPaymentType()).orElseThrow(() -> new IOException("Missing payment type")).name();
        SCALoginResponseTO scaResponseTO = (SCALoginResponseTO)this.tokenStorageService.fromBytes(aspspConsentData, SCALoginResponseTO.class);
        SCAPaymentResponseTO paymentResponse = this.scaLoginMapper.toPaymentResponse(scaResponseTO);
        paymentResponse.setObjectType(SCAPaymentResponseTO.class.getSimpleName());
        paymentResponse.setPaymentId(businessObject.getPaymentId());
        paymentResponse.setPaymentType(PaymentTypeTO.valueOf((String)paymentTypeString));
        String paymentProduct = businessObject.getPaymentProduct();
        if (originalResponse == null || originalResponse.getPaymentProduct() == null) {
            throw new IOException("Missing payment product");
        }
        paymentProduct = originalResponse.getPaymentProduct();
        String unsupportedPaymentProductMessage = String.format("Unsupported payment product %s", paymentProduct);
        PaymentProductTO productTO = (PaymentProductTO)PaymentProductTO.getByValue((String)paymentProduct).orElseThrow(() -> new IOException(unsupportedPaymentProductMessage));
        paymentResponse.setPaymentProduct(productTO.getValue());
        paymentResponse.setMultilevelScaRequired(originalResponse.isMultilevelScaRequired());
        return paymentResponse;
    }

    @Override
    protected boolean validateStatuses(SpiPayment businessObject, SCAPaymentResponseTO sca) {
        return businessObject.getPaymentStatus() == TransactionStatus.RCVD || sca.getScaStatus() == ScaStatusTO.EXEMPTED;
    }

    @Override
    protected boolean isFirstInitiationOfMultilevelSca(SpiPayment businessObject, SCAPaymentResponseTO scaPaymentResponseTO) {
        return true;
    }

    @Override
    protected Optional<List<ScaUserDataTO>> getScaMethods(SCAPaymentResponseTO sca) {
        this.authRequestInterceptor.setAccessToken(sca.getBearerToken().getAccess_token());
        ResponseEntity cancelSCA = this.paymentRestClient.getCancelSCA(sca.getPaymentId(), sca.getAuthorisationId());
        return Optional.ofNullable(cancelSCA.getBody()).map(SCAResponseTO::getScaMethods);
    }
}

