/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.aspsp.xs2a.connector.spi.impl.payment.internal;

import de.adorsys.aspsp.xs2a.connector.spi.converter.LedgersSpiPaymentToMapper;
import de.adorsys.aspsp.xs2a.connector.spi.converter.StandardPaymentProductsResolverConnector;
import de.adorsys.aspsp.xs2a.connector.spi.impl.payment.GeneralPaymentService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import org.springframework.stereotype.Service;

@Service
public class PaymentInternalGeneral {
    private final StandardPaymentProductsResolverConnector standardPaymentProductsResolverConnector;
    private final LedgersSpiPaymentToMapper ledgersSpiPaymentToMapper;
    private final GeneralPaymentService paymentService;

    public SCAPaymentResponseTO initiatePaymentInternal(SpiPayment payment, byte[] initialAspspConsentData) {
        PaymentType paymentType = payment.getPaymentType();
        PaymentTO paymentTO = this.buildPaymentTO(paymentType, (SpiPaymentInfo)payment);
        return this.paymentService.initiatePaymentInternal(payment, initialAspspConsentData, PaymentTypeTO.valueOf((String)paymentType.toString()), paymentTO);
    }

    private PaymentTO buildPaymentTO(PaymentType paymentType, SpiPaymentInfo spiPaymentInfo) {
        if (this.standardPaymentProductsResolverConnector.isRawPaymentProduct(spiPaymentInfo.getPaymentProduct())) {
            return this.ledgersSpiPaymentToMapper.toCommonPaymentTO(spiPaymentInfo);
        }
        switch (paymentType) {
            case SINGLE: {
                return this.ledgersSpiPaymentToMapper.toPaymentTO_Single(spiPaymentInfo);
            }
            case BULK: {
                return this.ledgersSpiPaymentToMapper.toPaymentTO_Bulk(spiPaymentInfo);
            }
            case PERIODIC: {
                return this.ledgersSpiPaymentToMapper.toPaymentTO_Periodic(spiPaymentInfo);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown payment type: %s", paymentType.getValue()));
    }

    public PaymentInternalGeneral(StandardPaymentProductsResolverConnector standardPaymentProductsResolverConnector, LedgersSpiPaymentToMapper ledgersSpiPaymentToMapper, GeneralPaymentService paymentService) {
        this.standardPaymentProductsResolverConnector = standardPaymentProductsResolverConnector;
        this.ledgersSpiPaymentToMapper = ledgersSpiPaymentToMapper;
        this.paymentService = paymentService;
    }
}

