/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

public enum BankAccountType {
    GIRO,
    SAVINGS,
    FIXEDTERMDEPOSIT,
    DEPOT,
    LOAN,
    CREDITCARD,
    BUIILDINGSAVING,
    INSURANCE,
    UNKNOWN;

    private Integer rawType;

    public static BankAccountType fromHbciType(Integer hbciAccountType) {
        if (hbciAccountType == null || hbciAccountType == 0) {
            return UNKNOWN.rawType(hbciAccountType);
        }
        if (hbciAccountType < 10) {
            return GIRO.rawType(hbciAccountType);
        }
        if (hbciAccountType < 20) {
            return SAVINGS.rawType(hbciAccountType);
        }
        if (hbciAccountType < 30) {
            return FIXEDTERMDEPOSIT.rawType(hbciAccountType);
        }
        if (hbciAccountType < 40) {
            return DEPOT.rawType(hbciAccountType);
        }
        if (hbciAccountType < 50) {
            return LOAN.rawType(hbciAccountType);
        }
        if (hbciAccountType < 60) {
            return CREDITCARD.rawType(hbciAccountType);
        }
        if (hbciAccountType < 70) {
            return DEPOT.rawType(hbciAccountType);
        }
        if (hbciAccountType < 80) {
            return BUIILDINGSAVING.rawType(hbciAccountType);
        }
        if (hbciAccountType < 90) {
            return INSURANCE.rawType(hbciAccountType);
        }
        return UNKNOWN.rawType(hbciAccountType);
    }

    public static BankAccountType fromFigoType(String type) {
        if (type == null) {
            return UNKNOWN;
        }
        if (type.equalsIgnoreCase("Giro account")) {
            return GIRO;
        }
        if (type.equalsIgnoreCase("Credit card")) {
            return CREDITCARD;
        }
        if (type.equalsIgnoreCase("Savings account")) {
            return SAVINGS;
        }
        if (type.equalsIgnoreCase("Depot")) {
            return DEPOT;
        }
        if (type.equalsIgnoreCase("Loan account")) {
            return LOAN;
        }
        return UNKNOWN;
    }

    public static BankAccountType fromFinapiType(Integer type) {
        if (type == null) {
            return UNKNOWN;
        }
        switch (type) {
            case 1: {
                return GIRO;
            }
            case 2: {
                return SAVINGS;
            }
            case 3: {
                return CREDITCARD;
            }
            case 4: {
                return INSURANCE;
            }
            case 5: {
                return LOAN;
            }
            case 7: {
                return DEPOT;
            }
        }
        return UNKNOWN;
    }

    public static BankAccountType fromXS2AType(String xs2aAccountType) {
        switch (xs2aAccountType) {
            case "CACC": 
            case "CASH": 
            case "TRAN": {
                return GIRO;
            }
            case "SVGS": 
            case "LLSV": {
                return SAVINGS;
            }
            case "LOAN": {
                return LOAN;
            }
            case "CHAR": 
            case "CISH": 
            case "COMM": 
            case "CPAC": 
            case "MGLD": 
            case "MOMA": 
            case "NREX": 
            case "ODFT": 
            case "ONDP": 
            case "SACC": 
            case "SLRY": 
            case "TAXE": 
            case "OTHR": {
                return UNKNOWN;
            }
        }
        return UNKNOWN;
    }

    public BankAccountType rawType(Integer rawType) {
        this.rawType = rawType;
        return this;
    }

    public Integer getRawType() {
        return this.rawType;
    }
}

