/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain;

import de.adorsys.multibanking.domain.ExecutedBooking;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

public class BookingPeriod {
    private LocalDate start;
    private LocalDate end;
    private BigDecimal amount;
    private List<ExecutedBooking> bookings;

    BookingPeriod(LocalDate start, LocalDate end, BigDecimal amount, List<ExecutedBooking> bookings) {
        this.start = start;
        this.end = end;
        this.amount = amount;
        this.bookings = bookings;
    }

    public static BookingPeriodBuilder builder() {
        return new BookingPeriodBuilder();
    }

    public LocalDate getStart() {
        return this.start;
    }

    public LocalDate getEnd() {
        return this.end;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public List<ExecutedBooking> getBookings() {
        return this.bookings;
    }

    public void setStart(LocalDate start) {
        this.start = start;
    }

    public void setEnd(LocalDate end) {
        this.end = end;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setBookings(List<ExecutedBooking> bookings) {
        this.bookings = bookings;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookingPeriod)) {
            return false;
        }
        BookingPeriod other = (BookingPeriod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDate this$start = this.getStart();
        LocalDate other$start = other.getStart();
        if (this$start == null ? other$start != null : !((Object)this$start).equals(other$start)) {
            return false;
        }
        LocalDate this$end = this.getEnd();
        LocalDate other$end = other.getEnd();
        if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        List<ExecutedBooking> this$bookings = this.getBookings();
        List<ExecutedBooking> other$bookings = other.getBookings();
        return !(this$bookings == null ? other$bookings != null : !((Object)this$bookings).equals(other$bookings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BookingPeriod;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $start = this.getStart();
        result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
        LocalDate $end = this.getEnd();
        result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        List<ExecutedBooking> $bookings = this.getBookings();
        result = result * 59 + ($bookings == null ? 43 : ((Object)$bookings).hashCode());
        return result;
    }

    public String toString() {
        return "BookingPeriod(start=" + this.getStart() + ", end=" + this.getEnd() + ", amount=" + this.getAmount() + ", bookings=" + this.getBookings() + ")";
    }

    public static class BookingPeriodBuilder {
        private LocalDate start;
        private LocalDate end;
        private BigDecimal amount;
        private List<ExecutedBooking> bookings;

        BookingPeriodBuilder() {
        }

        public BookingPeriodBuilder start(LocalDate start) {
            this.start = start;
            return this;
        }

        public BookingPeriodBuilder end(LocalDate end) {
            this.end = end;
            return this;
        }

        public BookingPeriodBuilder amount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public BookingPeriodBuilder bookings(List<ExecutedBooking> bookings) {
            this.bookings = bookings;
            return this;
        }

        public BookingPeriod build() {
            return new BookingPeriod(this.start, this.end, this.amount, this.bookings);
        }

        public String toString() {
            return "BookingPeriod.BookingPeriodBuilder(start=" + this.start + ", end=" + this.end + ", amount=" + this.amount + ", bookings=" + this.bookings + ")";
        }
    }
}

