/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain.exception;

import de.adorsys.multibanking.domain.PsuMessage;
import de.adorsys.multibanking.domain.exception.Message;
import de.adorsys.multibanking.domain.exception.MultibankingError;
import java.util.Collections;
import java.util.List;

public class MultibankingException
extends RuntimeException {
    private final int httpResponseCode;
    private final List<PsuMessage> psuMessages;
    private final List<Message> tppMessages;
    private final MultibankingError multibankingError;

    public MultibankingException(MultibankingError multibankingError) {
        this(multibankingError, 400, Collections.emptyList(), null);
    }

    public MultibankingException(MultibankingError multibankingError, int httpResponseCode, String psuMessage) {
        this(multibankingError, httpResponseCode, Collections.singletonList(new PsuMessage(null, psuMessage)), null);
    }

    public MultibankingException(MultibankingError multibankingError, String psuMessage) {
        this(multibankingError, 400, Collections.singletonList(new PsuMessage(null, psuMessage)), null);
    }

    public MultibankingException(MultibankingError multibankingError, List<PsuMessage> psuMessages) {
        this(multibankingError, 400, psuMessages, null);
    }

    public MultibankingException(MultibankingError multibankingError, int httpResponseCode, List<PsuMessage> psuMessages, List<Message> tppMessages) {
        super(MultibankingException.toExceptionString(psuMessages, tppMessages));
        this.psuMessages = psuMessages;
        this.multibankingError = multibankingError;
        this.httpResponseCode = httpResponseCode;
        this.tppMessages = tppMessages;
    }

    @Override
    public String toString() {
        return MultibankingException.toExceptionString(this.psuMessages, this.tppMessages);
    }

    private static String toExceptionString(List<PsuMessage> psuMessages, List<Message> tppMessages) {
        StringBuilder stringBuilder = new StringBuilder();
        if (psuMessages != null) {
            psuMessages.forEach(psuMessage -> stringBuilder.append(psuMessage.toString()).append("\\n"));
        }
        if (tppMessages != null) {
            tppMessages.forEach(tppMessage -> stringBuilder.append(tppMessage.toString()).append("\\n"));
        }
        return stringBuilder.toString();
    }

    public int getHttpResponseCode() {
        return this.httpResponseCode;
    }

    public List<PsuMessage> getPsuMessages() {
        return this.psuMessages;
    }

    public List<Message> getTppMessages() {
        return this.tppMessages;
    }

    public MultibankingError getMultibankingError() {
        return this.multibankingError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultibankingException)) {
            return false;
        }
        MultibankingException other = (MultibankingException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHttpResponseCode() != other.getHttpResponseCode()) {
            return false;
        }
        List<PsuMessage> this$psuMessages = this.getPsuMessages();
        List<PsuMessage> other$psuMessages = other.getPsuMessages();
        if (this$psuMessages == null ? other$psuMessages != null : !((Object)this$psuMessages).equals(other$psuMessages)) {
            return false;
        }
        List<Message> this$tppMessages = this.getTppMessages();
        List<Message> other$tppMessages = other.getTppMessages();
        if (this$tppMessages == null ? other$tppMessages != null : !((Object)this$tppMessages).equals(other$tppMessages)) {
            return false;
        }
        MultibankingError this$multibankingError = this.getMultibankingError();
        MultibankingError other$multibankingError = other.getMultibankingError();
        return !(this$multibankingError == null ? other$multibankingError != null : !((Object)((Object)this$multibankingError)).equals((Object)other$multibankingError));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultibankingException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getHttpResponseCode();
        List<PsuMessage> $psuMessages = this.getPsuMessages();
        result = result * 59 + ($psuMessages == null ? 43 : ((Object)$psuMessages).hashCode());
        List<Message> $tppMessages = this.getTppMessages();
        result = result * 59 + ($tppMessages == null ? 43 : ((Object)$tppMessages).hashCode());
        MultibankingError $multibankingError = this.getMultibankingError();
        result = result * 59 + ($multibankingError == null ? 43 : ((Object)((Object)$multibankingError)).hashCode());
        return result;
    }
}

