/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.domain.utils;

import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static Pattern creditorIdRegex = Pattern.compile("([deDE]{2}[0-9]{2,2}[A-Za-z0-9]{3,3}[0]{1}[0-9]{10})", 2);
    private static Pattern ibanRegex = Pattern.compile("([A-Z]{2}\\d{2} ?\\d{4} ?\\d{4} ?\\d{4} ?\\d{4} ?[\\d]{0,2})", 2);
    private static Pattern mandateReferenceRegex = Pattern.compile("(?:mref|mandatsreferenz|mandatsref|mandat)[:\\+]?\\s*(\\S+?)(?:\\s+|\\+|CRED|MANDATSDATUM|EINREICHER-ID)", 2);
    private static Pattern abwaRegex = Pattern.compile("(?:abwa\\+)(.*)", 2);

    public static String extractCreditorId(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = creditorIdRegex.matcher(input);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static String extractDifferentInitiator(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = abwaRegex.matcher(input);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractIban(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = ibanRegex.matcher(input);
        if (matcher.find()) {
            return matcher.group(0).toUpperCase();
        }
        return null;
    }

    public static String extractMandateReference(String input) {
        if (input == null) {
            return null;
        }
        Matcher matcher = mandateReferenceRegex.matcher(input);
        if (matcher.find()) {
            return matcher.group(1).replace("+", " ");
        }
        return null;
    }

    public static SecureRandom getSecureRandom() {
        try {
            SecureRandom random = new SecureRandom();
            byte[] seed = random.generateSeed(20);
            random.setSeed(seed);
            return random;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean inCycle(LocalDate buchungsdatum, int executionDay) {
        boolean inInterval1 = Utils.inCycle(buchungsdatum.minusMonths(1L), buchungsdatum, executionDay);
        boolean inInterval2 = Utils.inCycle(buchungsdatum, buchungsdatum, executionDay);
        boolean inInterval3 = Utils.inCycle(buchungsdatum.plusMonths(1L), buchungsdatum, executionDay);
        return inInterval1 || inInterval2 || inInterval3;
    }

    private static boolean inCycle(LocalDate datum, LocalDate buchungsdatum, int executionDay) {
        LocalDate ausfuehrungsDatum = Utils.calcExecutionDate(datum, executionDay);
        LocalDate startDatum = ausfuehrungsDatum.minusDays(7L);
        LocalDate endDatum = ausfuehrungsDatum.plusDays(7L);
        return startDatum.isBefore(buchungsdatum) && endDatum.isAfter(buchungsdatum);
    }

    private static LocalDate calcExecutionDate(LocalDate localDate, int executionDay) {
        int jahr = localDate.getYear();
        int month = localDate.getMonthValue();
        int maxDays = YearMonth.from(localDate).lengthOfMonth();
        switch (executionDay) {
            case 99: {
                return LocalDate.of(jahr, month, maxDays);
            }
            case 98: {
                return LocalDate.of(jahr, month, maxDays - 1);
            }
            case 97: {
                return LocalDate.of(jahr, month, maxDays - 2);
            }
        }
        return LocalDate.of(jahr, month, Math.min(executionDay, maxDays));
    }

    public static boolean usageContains(String bookingUsage, String standingOrderUsage) {
        return bookingUsage != null && standingOrderUsage != null && Utils.normalizeUsage(bookingUsage).contains(Utils.normalizeUsage(standingOrderUsage));
    }

    private static String normalizeUsage(String vwz) {
        return Utils.normalizeUsageUmlaute(vwz).replaceAll("\\W", "").toLowerCase();
    }

    private static String normalizeUsageUmlaute(String vwz) {
        return vwz.replace("\u00c4", "Ae").replace("\u00e4", "ae").replace("\u00dc", "Ue").replace("\u00fc", "ue").replace("\u00d6", "Oe").replace("\u00f6", "oe").replace("\u00df", "ss");
    }
}

