/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import de.adorsys.multibanking.domain.BankAccount;
import de.adorsys.multibanking.domain.BankApi;
import de.adorsys.multibanking.domain.BankApiUser;
import de.adorsys.multibanking.domain.ScaStatus;
import de.adorsys.multibanking.domain.request.AbstractRequest;
import de.adorsys.multibanking.domain.request.TransactionRequest;
import de.adorsys.multibanking.domain.response.AbstractResponse;
import de.adorsys.multibanking.domain.response.AccountInformationResponse;
import de.adorsys.multibanking.domain.response.LoadBalancesResponse;
import de.adorsys.multibanking.domain.response.PaymentResponse;
import de.adorsys.multibanking.domain.response.StandingOrdersResponse;
import de.adorsys.multibanking.domain.response.TransactionAuthorisationResponse;
import de.adorsys.multibanking.domain.response.TransactionsResponse;
import de.adorsys.multibanking.domain.spi.OnlineBankingService;
import de.adorsys.multibanking.domain.spi.StrongCustomerAuthorisable;
import de.adorsys.multibanking.domain.transaction.AbstractPayment;
import de.adorsys.multibanking.domain.transaction.AbstractTransaction;
import de.adorsys.multibanking.domain.transaction.LoadAccounts;
import de.adorsys.multibanking.domain.transaction.LoadBalances;
import de.adorsys.multibanking.domain.transaction.LoadStandingOrders;
import de.adorsys.multibanking.domain.transaction.LoadTransactions;
import de.adorsys.multibanking.domain.transaction.TransactionAuthorisation;
import de.adorsys.multibanking.hbci.HbciBpdUpdCallback;
import de.adorsys.multibanking.hbci.HbciCacheHandler;
import de.adorsys.multibanking.hbci.HbciExceptionHandler;
import de.adorsys.multibanking.hbci.HbciScaHandler;
import de.adorsys.multibanking.hbci.job.AccountInformationJob;
import de.adorsys.multibanking.hbci.job.BulkPaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteFutureBulkPaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteFutureSinglePaymentJob;
import de.adorsys.multibanking.hbci.job.DeleteStandingOrderJob;
import de.adorsys.multibanking.hbci.job.ForeignPaymentJob;
import de.adorsys.multibanking.hbci.job.InstantPaymentStatusJob;
import de.adorsys.multibanking.hbci.job.LoadBalancesJob;
import de.adorsys.multibanking.hbci.job.LoadStandingOrdersJob;
import de.adorsys.multibanking.hbci.job.LoadTransactionsJob;
import de.adorsys.multibanking.hbci.job.NewStandingOrderJob;
import de.adorsys.multibanking.hbci.job.RawSepaJob;
import de.adorsys.multibanking.hbci.job.ScaAwareJob;
import de.adorsys.multibanking.hbci.job.SinglePaymentJob;
import de.adorsys.multibanking.hbci.job.TanRequestJob;
import de.adorsys.multibanking.hbci.job.TransactionAuthorisationJob;
import de.adorsys.multibanking.hbci.job.TransferJob;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.exceptions.HBCI_Exception;
import org.kapott.hbci.manager.HBCIProduct;
import org.kapott.hbci.manager.HBCIUtils;

public class HbciBanking
implements OnlineBankingService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private HbciScaHandler hbciScaHandler;
    private long sysIdExpirationTimeMs;
    private long updExpirationTimeMs;

    public HbciBanking(HBCIProduct hbciProduct, long sysIdExpirationTimeMs, long updExpirationTimeMs) {
        this(hbciProduct, null, sysIdExpirationTimeMs, updExpirationTimeMs);
    }

    public HbciBanking(HBCIProduct hbciProduct, InputStream customBankConfigInput, long sysIdExpirationTimeMs, long updExpirationTimeMs) {
        this.hbciScaHandler = new HbciScaHandler(hbciProduct, sysIdExpirationTimeMs, updExpirationTimeMs);
        try (InputStream inputStream = Optional.ofNullable(customBankConfigInput).orElseGet(this::getDefaultBanksInput);){
            HBCIUtils.refreshBLZList((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        OBJECT_MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.registerModule((Module)new Jdk8Module());
        this.sysIdExpirationTimeMs = sysIdExpirationTimeMs;
        this.updExpirationTimeMs = updExpirationTimeMs;
    }

    private InputStream getDefaultBanksInput() {
        return Optional.ofNullable(HBCIUtils.class.getClassLoader().getResource("blz.properties")).map(url -> {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }).orElseThrow(() -> new RuntimeException("blz.properties not exists in classpath"));
    }

    public BankApi bankApi() {
        return BankApi.HBCI;
    }

    public boolean externalBankAccountRequired() {
        return false;
    }

    public boolean userRegistrationRequired() {
        return false;
    }

    public BankApiUser registerUser(String userId) {
        return null;
    }

    public void removeUser(BankApiUser bankApiUser) {
    }

    public boolean bookingsCategorized() {
        return false;
    }

    public AccountInformationResponse loadBankAccounts(TransactionRequest<LoadAccounts> request) {
        HbciConsent hbciConsent = (HbciConsent)request.getBankApiConsentData();
        hbciConsent.checkUpdSysIdCache(this.sysIdExpirationTimeMs, this.updExpirationTimeMs);
        try {
            if (hbciConsent.getHbciTanSubmit() == null || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                HbciBpdUpdCallback hbciCallback = HbciCacheHandler.createCallback(request);
                AccountInformationJob accountInformationJob = new AccountInformationJob(request);
                AccountInformationResponse response = (AccountInformationResponse)accountInformationJob.execute((HBCICallback)hbciCallback);
                response.setBankApiConsentData((Object)hbciCallback.updateConsentUpd(hbciConsent));
                return response;
            }
            TransactionAuthorisationResponse transactionAuthorisationResponse = this.transactionAuthorisation(new TransactionAuthorisation(request));
            hbciConsent.afterTransactionAuthorisation(transactionAuthorisationResponse.getScaStatus());
            return (AccountInformationResponse)transactionAuthorisationResponse.getJobResponse();
        }
        catch (HBCI_Exception e) {
            throw HbciExceptionHandler.handleHbciException(e);
        }
    }

    public TransactionsResponse loadTransactions(TransactionRequest<LoadTransactions> loadTransactionsRequest) {
        HbciConsent hbciConsent = (HbciConsent)loadTransactionsRequest.getBankApiConsentData();
        hbciConsent.checkUpdSysIdCache(this.sysIdExpirationTimeMs, this.updExpirationTimeMs);
        try {
            if (hbciConsent.getHbciTanSubmit() == null || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                HbciBpdUpdCallback hbciCallback = HbciCacheHandler.createCallback(loadTransactionsRequest);
                LoadTransactionsJob loadBookingsJob = new LoadTransactionsJob(loadTransactionsRequest);
                TransactionsResponse response = (TransactionsResponse)loadBookingsJob.execute((HBCICallback)hbciCallback);
                response.setBankApiConsentData((Object)hbciCallback.updateConsentUpd(hbciConsent));
                return response;
            }
            TransactionAuthorisationResponse transactionAuthorisationResponse = this.transactionAuthorisation(new TransactionAuthorisation(loadTransactionsRequest));
            hbciConsent.afterTransactionAuthorisation(transactionAuthorisationResponse.getScaStatus());
            return (TransactionsResponse)transactionAuthorisationResponse.getJobResponse();
        }
        catch (HBCI_Exception e) {
            throw HbciExceptionHandler.handleHbciException(e);
        }
    }

    public StandingOrdersResponse loadStandingOrders(TransactionRequest<LoadStandingOrders> loadStandingOrdersRequest) {
        HbciConsent hbciConsent = (HbciConsent)loadStandingOrdersRequest.getBankApiConsentData();
        hbciConsent.checkUpdSysIdCache(this.sysIdExpirationTimeMs, this.updExpirationTimeMs);
        try {
            if (hbciConsent.getHbciTanSubmit() == null || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                HbciBpdUpdCallback hbciCallback = HbciCacheHandler.createCallback(loadStandingOrdersRequest);
                LoadStandingOrdersJob loadStandingOrdersJob = new LoadStandingOrdersJob(loadStandingOrdersRequest);
                StandingOrdersResponse response = (StandingOrdersResponse)loadStandingOrdersJob.execute((HBCICallback)hbciCallback);
                response.setBankApiConsentData((Object)hbciCallback.updateConsentUpd(hbciConsent));
                return response;
            }
            TransactionAuthorisationResponse transactionAuthorisationResponse = this.transactionAuthorisation(new TransactionAuthorisation(loadStandingOrdersRequest));
            hbciConsent.afterTransactionAuthorisation(transactionAuthorisationResponse.getScaStatus());
            return (StandingOrdersResponse)transactionAuthorisationResponse.getJobResponse();
        }
        catch (HBCI_Exception e) {
            throw HbciExceptionHandler.handleHbciException(e);
        }
    }

    public LoadBalancesResponse loadBalances(TransactionRequest<LoadBalances> request) {
        HbciConsent hbciConsent = (HbciConsent)request.getBankApiConsentData();
        hbciConsent.checkUpdSysIdCache(this.sysIdExpirationTimeMs, this.updExpirationTimeMs);
        try {
            if (hbciConsent.getHbciTanSubmit() == null || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                HbciBpdUpdCallback hbciCallback = HbciCacheHandler.createCallback(request);
                LoadBalancesJob loadBalancesJob = new LoadBalancesJob(request);
                LoadBalancesResponse response = (LoadBalancesResponse)loadBalancesJob.execute((HBCICallback)hbciCallback);
                response.setBankApiConsentData((Object)hbciCallback.updateConsentUpd(hbciConsent));
                return response;
            }
            TransactionAuthorisationResponse transactionAuthorisationResponse = this.transactionAuthorisation(new TransactionAuthorisation(request));
            hbciConsent.afterTransactionAuthorisation(transactionAuthorisationResponse.getScaStatus());
            return (LoadBalancesResponse)transactionAuthorisationResponse.getJobResponse();
        }
        catch (HBCI_Exception e) {
            throw HbciExceptionHandler.handleHbciException(e);
        }
    }

    public PaymentResponse executePayment(TransactionRequest<? extends AbstractPayment> request) {
        HbciConsent hbciConsent = (HbciConsent)request.getBankApiConsentData();
        hbciConsent.checkUpdSysIdCache(this.sysIdExpirationTimeMs, this.updExpirationTimeMs);
        try {
            if (hbciConsent.getHbciTanSubmit() == null || hbciConsent.getStatus() == ScaStatus.FINALISED) {
                HbciBpdUpdCallback hbciCallback = HbciCacheHandler.createCallback(request);
                ScaAwareJob paymentJob = this.createScaJob(request);
                PaymentResponse response = (PaymentResponse)paymentJob.execute((HBCICallback)hbciCallback);
                response.setBankApiConsentData((Object)hbciCallback.updateConsentUpd(hbciConsent));
                return response;
            }
            TransactionAuthorisationResponse transactionAuthorisationResponse = this.transactionAuthorisation(new TransactionAuthorisation(request));
            hbciConsent.afterTransactionAuthorisation(transactionAuthorisationResponse.getScaStatus());
            return (PaymentResponse)transactionAuthorisationResponse.getJobResponse();
        }
        catch (HBCI_Exception e) {
            throw HbciExceptionHandler.handleHbciException(e);
        }
    }

    public StrongCustomerAuthorisable getStrongCustomerAuthorisation() {
        return this.hbciScaHandler;
    }

    private <T extends AbstractTransaction, R extends AbstractResponse> TransactionAuthorisationResponse<R> transactionAuthorisation(TransactionAuthorisation<T> transactionAuthorisation) {
        HbciCacheHandler.createCallback((AbstractRequest)transactionAuthorisation.getOriginTransactionRequest());
        try {
            ScaAwareJob<T, R> scaJob = this.createScaJob(transactionAuthorisation.getOriginTransactionRequest());
            TransactionAuthorisationJob<T, R> transactionAuthorisationJob = new TransactionAuthorisationJob<T, R>(scaJob, transactionAuthorisation);
            TransactionAuthorisationResponse<R> response = transactionAuthorisationJob.execute();
            HbciConsent hbciConsent = (HbciConsent)transactionAuthorisation.getOriginTransactionRequest().getBankApiConsentData();
            hbciConsent.afterTransactionAuthorisation(response.getScaStatus());
            return response;
        }
        catch (HBCI_Exception e) {
            throw HbciExceptionHandler.handleHbciException(e);
        }
    }

    public void removeBankAccount(BankAccount bankAccount, BankApiUser bankApiUser) {
    }

    public boolean bankSupported(String bankCode) {
        return Optional.ofNullable(HBCIUtils.getBankInfo((String)bankCode)).map(bankInfo -> bankInfo.getPinTanVersion() != null).orElse(false);
    }

    private <T extends AbstractTransaction, R extends AbstractResponse> ScaAwareJob<T, R> createScaJob(TransactionRequest<T> transactionRequest) {
        switch (transactionRequest.getTransaction().getTransactionType()) {
            case SINGLE_PAYMENT: 
            case FUTURE_SINGLE_PAYMENT: 
            case INSTANT_PAYMENT: {
                return new SinglePaymentJob(transactionRequest);
            }
            case TRANSFER_PAYMENT: {
                return new TransferJob(transactionRequest);
            }
            case FOREIGN_PAYMENT: {
                return new ForeignPaymentJob(transactionRequest);
            }
            case BULK_PAYMENT: 
            case FUTURE_BULK_PAYMENT: {
                return new BulkPaymentJob(transactionRequest);
            }
            case STANDING_ORDER: {
                return new NewStandingOrderJob(transactionRequest);
            }
            case RAW_SEPA: {
                return new RawSepaJob(transactionRequest);
            }
            case FUTURE_SINGLE_PAYMENT_DELETE: {
                return new DeleteFutureSinglePaymentJob(transactionRequest);
            }
            case FUTURE_BULK_PAYMENT_DELETE: {
                return new DeleteFutureBulkPaymentJob(transactionRequest);
            }
            case STANDING_ORDER_DELETE: {
                return new DeleteStandingOrderJob(transactionRequest);
            }
            case TAN_REQUEST: {
                return new TanRequestJob(transactionRequest);
            }
            case LOAD_BANKACCOUNTS: {
                return new AccountInformationJob(transactionRequest);
            }
            case LOAD_BALANCES: {
                return new LoadBalancesJob(transactionRequest);
            }
            case LOAD_TRANSACTIONS: {
                return new LoadTransactionsJob(transactionRequest);
            }
            case LOAD_STANDING_ORDERS: {
                return new LoadStandingOrdersJob(transactionRequest);
            }
            case GET_PAYMENT_STATUS: {
                return new InstantPaymentStatusJob(transactionRequest);
            }
        }
        throw new IllegalArgumentException("invalid transaction type " + transactionRequest.getTransaction().getTransactionType());
    }
}

