/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.multibanking.hbci;

import de.adorsys.multibanking.domain.ScaApproach;
import de.adorsys.multibanking.domain.TanTransportType;
import de.adorsys.multibanking.domain.response.CreateConsentResponse;
import de.adorsys.multibanking.domain.response.UpdateAuthResponse;
import de.adorsys.multibanking.hbci.HbciScaMapper;
import de.adorsys.multibanking.hbci.model.HbciConsent;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

class HbciScaMapperImpl
implements HbciScaMapper {
    HbciScaMapperImpl() {
    }

    @Override
    public CreateConsentResponse toCreateConsentResponse(HbciConsent bankApiConsentData) {
        if (bankApiConsentData == null) {
            return null;
        }
        CreateConsentResponse createConsentResponse = new CreateConsentResponse();
        createConsentResponse.setAuthorisationId(UUID.randomUUID().toString());
        createConsentResponse.setBankApiConsentData((Object)bankApiConsentData);
        createConsentResponse.setConsentId(UUID.randomUUID().toString());
        createConsentResponse.setScaApproach(ScaApproach.EMBEDDED);
        return createConsentResponse;
    }

    @Override
    public UpdateAuthResponse toUpdateAuthResponse(HbciConsent hbciConsent, UpdateAuthResponse updateAuthResponse) {
        if (hbciConsent == null) {
            return null;
        }
        updateAuthResponse.setBankApiConsentData((Object)hbciConsent);
        if (updateAuthResponse.getScaMethods() != null) {
            List<TanTransportType> list = hbciConsent.getTanMethodList();
            if (list != null) {
                updateAuthResponse.getScaMethods().clear();
                updateAuthResponse.getScaMethods().addAll(list);
            } else {
                updateAuthResponse.setScaMethods(null);
            }
        } else {
            List<TanTransportType> list = hbciConsent.getTanMethodList();
            if (list != null) {
                updateAuthResponse.setScaMethods(new ArrayList<TanTransportType>(list));
            }
        }
        return updateAuthResponse;
    }
}

