/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.config;

import de.adorsys.psd2.consent.config.ServiceInstanceIdEventListener;
import java.beans.ConstructorProperties;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jpa.HibernateEntityManagerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HibernateListenerConfig {
    @PersistenceUnit
    private EntityManagerFactory entityManagerFactory;
    private final ServiceInstanceIdEventListener serviceInstanceIdEventListener;

    @PostConstruct
    public void registerListeners() {
        if (this.entityManagerFactory instanceof HibernateEntityManagerFactory) {
            HibernateEntityManagerFactory hibernateEntityManagerFactory = (HibernateEntityManagerFactory)this.entityManagerFactory;
            SessionFactoryImpl sessionFactory = (SessionFactoryImpl)hibernateEntityManagerFactory.getSessionFactory();
            EventListenerRegistry registry = (EventListenerRegistry)sessionFactory.getServiceRegistry().getService(EventListenerRegistry.class);
            registry.getEventListenerGroup(EventType.PRE_INSERT).appendListener((Object)this.serviceInstanceIdEventListener);
        }
    }

    @ConstructorProperties(value={"serviceInstanceIdEventListener"})
    public HibernateListenerConfig(ServiceInstanceIdEventListener serviceInstanceIdEventListener) {
        this.serviceInstanceIdEventListener = serviceInstanceIdEventListener;
    }
}

