/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.aspsp.controller;

import de.adorsys.psd2.consent.aspsp.api.psu.CmsAspspPsuAccountService;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"aspsp-api/v1/psu/consent"})
@Api(value="aspsp-api/v1/psu/consent", tags={"ASPSP PSU consent management"})
public class CmsAspspPsuConsentManagementController {
    private static final String DEFAULT_SERVICE_INSTANCE_ID = "UNDEFINED";
    private final CmsAspspPsuAccountService cmsAspspPsuAccountService;

    @DeleteMapping(path={"/all"})
    @ApiOperation(value="Close all PIIS and AIS consents for PSU or account")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Boolean.class), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<Boolean> closeAllConsents(@ApiParam(value="Bank specific account identifier.", example="11111-99999") @RequestHeader(value="account-id", required=false) String aspspAccountId, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. ") @RequestHeader(value="psu-id", required=false) String psuId, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="psu-id-type", required=false) String psuIdType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id", required=false) String psuCorporateId, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="psu-corporate-id-type", required=false) String psuCorporateIdType, @ApiParam(value="ID of the particular service instance") @RequestHeader(value="instance-id", required=false, defaultValue="UNDEFINED") String instanceId) {
        PsuIdData psuIdData = this.getPsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType);
        if (StringUtils.isBlank((CharSequence)aspspAccountId) && psuIdData.isEmpty()) {
            return new ResponseEntity((Object)false, HttpStatus.BAD_REQUEST);
        }
        boolean result = this.cmsAspspPsuAccountService.revokeAllConsents(aspspAccountId, psuIdData, instanceId);
        return new ResponseEntity((Object)result, result ? HttpStatus.OK : HttpStatus.BAD_REQUEST);
    }

    private PsuIdData getPsuIdData(String psuId, String psuIdType, String psuCorporateId, String psuCorporateIdType) {
        return new PsuIdData(psuId, psuIdType, psuCorporateId, psuCorporateIdType, null);
    }

    @ConstructorProperties(value={"cmsAspspPsuAccountService"})
    public CmsAspspPsuConsentManagementController(CmsAspspPsuAccountService cmsAspspPsuAccountService) {
        this.cmsAspspPsuAccountService = cmsAspspPsuAccountService;
    }
}

