/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.domain.account;

import de.adorsys.psd2.consent.api.ConsentType;
import de.adorsys.psd2.consent.api.ais.AdditionalAccountInformationType;
import de.adorsys.psd2.consent.domain.Authorisable;
import de.adorsys.psd2.consent.domain.AuthorisationTemplateEntity;
import de.adorsys.psd2.consent.domain.InstanceDependableEntity;
import de.adorsys.psd2.consent.domain.PsuData;
import de.adorsys.psd2.consent.domain.TppInfoEntity;
import de.adorsys.psd2.consent.domain.account.AisConsentUsage;
import de.adorsys.psd2.consent.domain.account.AspspAccountAccess;
import de.adorsys.psd2.consent.domain.account.TppAccountAccess;
import de.adorsys.psd2.xs2a.core.ais.AccountAccessType;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.AisConsentRequestType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.NotificationSupportedMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.SequenceGenerator;
import javax.persistence.Transient;
import org.apache.commons.collections4.CollectionUtils;

@Entity(name="ais_consent")
public class AisConsent
extends InstanceDependableEntity
implements Authorisable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ais_consent_generator")
    @SequenceGenerator(name="ais_consent_generator", sequenceName="ais_consent_id_seq", allocationSize=1)
    private Long id;
    @Column(name="external_id", nullable=false)
    private String externalId;
    @Column(name="recurring_indicator", nullable=false)
    private boolean recurringIndicator;
    @Column(name="tpp_redirect_preferred", nullable=false)
    private boolean tppRedirectPreferred;
    @Column(name="combined_service_indicator", nullable=false)
    private boolean combinedServiceIndicator;
    @Column(name="request_date_time", nullable=false)
    private LocalDateTime requestDateTime;
    @Column(name="last_action_date")
    private LocalDate lastActionDate;
    @Column(name="expire_date")
    private LocalDate expireDate;
    @Column(name="valid_until", nullable=false)
    private LocalDate validUntil;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinTable(name="ais_consent_psu_data", joinColumns={@JoinColumn(name="ais_consent_id")}, inverseJoinColumns={@JoinColumn(name="psu_data_id")})
    private List<PsuData> psuDataList = new ArrayList<PsuData>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="tpp_info_id", nullable=false)
    private TppInfoEntity tppInfo;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="authorisation_template_id", nullable=false)
    private AuthorisationTemplateEntity authorisationTemplate;
    @Column(name="tpp_ntfc_uri")
    private String tppNotificationUri;
    @ElementCollection
    @CollectionTable(name="ais_consent_tpp_ntfc", joinColumns={@JoinColumn(name="id")})
    @Column(name="notification_mode", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private List<NotificationSupportedMode> tppNotificationContentPreferred;
    @Column(name="consent_status", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ConsentStatus consentStatus;
    @Column(name="consent_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ConsentType consentType = ConsentType.AIS;
    @Column(name="expected_frequency_per_day", nullable=false)
    private int allowedFrequencyPerDay;
    @Column(name="tpp_frequency_per_day", nullable=false)
    private int tppFrequencyPerDay;
    @OneToMany(mappedBy="consent", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<AisConsentUsage> usages = new ArrayList<AisConsentUsage>();
    @ElementCollection
    @CollectionTable(name="ais_account_access", joinColumns={@JoinColumn(name="consent_id")})
    private List<TppAccountAccess> accesses = new ArrayList<TppAccountAccess>();
    @ElementCollection
    @CollectionTable(name="ais_aspsp_account_access", joinColumns={@JoinColumn(name="consent_id")})
    private List<AspspAccountAccess> aspspAccountAccesses = new ArrayList<AspspAccountAccess>();
    @Column(name="ais_consent_request_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private AisConsentRequestType aisConsentRequestType;
    @Column(name="creation_timestamp", nullable=false)
    private OffsetDateTime creationTimestamp = OffsetDateTime.now();
    @Column(name="available_accounts")
    @Enumerated(value=EnumType.STRING)
    private AccountAccessType availableAccounts;
    @Column(name="all_psd2")
    @Enumerated(value=EnumType.STRING)
    private AccountAccessType allPsd2;
    @Column(name="accounts_with_balances")
    @Enumerated(value=EnumType.STRING)
    private AccountAccessType availableAccountsWithBalance;
    @Column(name="multilevel_sca_required", nullable=false)
    private boolean multilevelScaRequired;
    @Column(name="status_change_timestamp")
    private OffsetDateTime statusChangeTimestamp;
    @Column(name="owner_name_type")
    @Enumerated(value=EnumType.STRING)
    private AdditionalAccountInformationType ownerNameType = AdditionalAccountInformationType.NONE;
    @Column(name="int_req_id")
    private String internalRequestId;
    @Lob
    @Column(name="checksum")
    private byte[] checksum;
    @Transient
    private ConsentStatus previousConsentStatus;

    @PostLoad
    public void aisConsentPostLoad() {
        this.previousConsentStatus = this.consentStatus;
    }

    @PreUpdate
    public void aisConsentPreUpdate() {
        if (this.previousConsentStatus != this.consentStatus) {
            this.statusChangeTimestamp = OffsetDateTime.now();
        }
    }

    @PrePersist
    public void aisConsentPrePersist() {
        if (Objects.isNull(this.statusChangeTimestamp)) {
            this.statusChangeTimestamp = this.creationTimestamp;
        }
    }

    public List<TppAccountAccess> getAccesses() {
        return new ArrayList<TppAccountAccess>(this.accesses);
    }

    public boolean isExpiredByDate() {
        return LocalDate.now().compareTo(this.validUntil) > 0;
    }

    public boolean isConfirmationExpired(long expirationPeriodMs) {
        if (this.isNotConfirmed()) {
            return this.creationTimestamp.plus(expirationPeriodMs, ChronoUnit.MILLIS).isBefore(OffsetDateTime.now());
        }
        return false;
    }

    public boolean isNotConfirmed() {
        return this.consentStatus == ConsentStatus.RECEIVED;
    }

    public void addAccountAccess(Set<TppAccountAccess> accountAccesses) {
        this.accesses = new ArrayList<TppAccountAccess>(accountAccesses);
    }

    public void addAspspAccountAccess(Set<AspspAccountAccess> aspspAccesses) {
        this.aspspAccountAccesses = new ArrayList<AspspAccountAccess>(aspspAccesses);
    }

    public boolean isOneAccessType() {
        return !this.recurringIndicator;
    }

    public boolean isWrongConsentData() {
        return CollectionUtils.isEmpty(this.psuDataList) || this.tppInfo == null;
    }

    public void addUsage(AisConsentUsage aisConsentUsage) {
        if (this.usages == null) {
            this.usages = new ArrayList<AisConsentUsage>();
        }
        this.usages.add(aisConsentUsage);
    }

    public boolean shouldConsentBeExpired() {
        return !this.getConsentStatus().isFinalisedStatus() && (this.isExpiredByDate() || this.isNonReccuringAlreadyUsed());
    }

    public boolean isNonReccuringAlreadyUsed() {
        return !this.recurringIndicator && this.usages.stream().anyMatch(u -> u.getUsageDate().isBefore(LocalDate.now()));
    }

    public boolean checkNoneAdditionalAccountInformation() {
        return this.getOwnerNameType() == AdditionalAccountInformationType.NONE;
    }

    @Override
    public String getInternalRequestId(AuthorisationType authorisationType) {
        if (authorisationType == AuthorisationType.AIS) {
            return this.internalRequestId;
        }
        throw new IllegalArgumentException("Invalid authorisation type: " + authorisationType);
    }

    public Long getId() {
        return this.id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    public boolean isRecurringIndicator() {
        return this.recurringIndicator;
    }

    public boolean isTppRedirectPreferred() {
        return this.tppRedirectPreferred;
    }

    public boolean isCombinedServiceIndicator() {
        return this.combinedServiceIndicator;
    }

    public LocalDateTime getRequestDateTime() {
        return this.requestDateTime;
    }

    public LocalDate getLastActionDate() {
        return this.lastActionDate;
    }

    public LocalDate getExpireDate() {
        return this.expireDate;
    }

    public LocalDate getValidUntil() {
        return this.validUntil;
    }

    @Override
    public List<PsuData> getPsuDataList() {
        return this.psuDataList;
    }

    public TppInfoEntity getTppInfo() {
        return this.tppInfo;
    }

    @Override
    public AuthorisationTemplateEntity getAuthorisationTemplate() {
        return this.authorisationTemplate;
    }

    public String getTppNotificationUri() {
        return this.tppNotificationUri;
    }

    public List<NotificationSupportedMode> getTppNotificationContentPreferred() {
        return this.tppNotificationContentPreferred;
    }

    public ConsentStatus getConsentStatus() {
        return this.consentStatus;
    }

    public ConsentType getConsentType() {
        return this.consentType;
    }

    public int getAllowedFrequencyPerDay() {
        return this.allowedFrequencyPerDay;
    }

    public int getTppFrequencyPerDay() {
        return this.tppFrequencyPerDay;
    }

    public List<AisConsentUsage> getUsages() {
        return this.usages;
    }

    public List<AspspAccountAccess> getAspspAccountAccesses() {
        return this.aspspAccountAccesses;
    }

    public AisConsentRequestType getAisConsentRequestType() {
        return this.aisConsentRequestType;
    }

    public OffsetDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public AccountAccessType getAvailableAccounts() {
        return this.availableAccounts;
    }

    public AccountAccessType getAllPsd2() {
        return this.allPsd2;
    }

    public AccountAccessType getAvailableAccountsWithBalance() {
        return this.availableAccountsWithBalance;
    }

    public boolean isMultilevelScaRequired() {
        return this.multilevelScaRequired;
    }

    public OffsetDateTime getStatusChangeTimestamp() {
        return this.statusChangeTimestamp;
    }

    public AdditionalAccountInformationType getOwnerNameType() {
        return this.ownerNameType;
    }

    public String getInternalRequestId() {
        return this.internalRequestId;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public ConsentStatus getPreviousConsentStatus() {
        return this.previousConsentStatus;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public void setRecurringIndicator(boolean recurringIndicator) {
        this.recurringIndicator = recurringIndicator;
    }

    public void setTppRedirectPreferred(boolean tppRedirectPreferred) {
        this.tppRedirectPreferred = tppRedirectPreferred;
    }

    public void setCombinedServiceIndicator(boolean combinedServiceIndicator) {
        this.combinedServiceIndicator = combinedServiceIndicator;
    }

    public void setRequestDateTime(LocalDateTime requestDateTime) {
        this.requestDateTime = requestDateTime;
    }

    public void setLastActionDate(LocalDate lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public void setExpireDate(LocalDate expireDate) {
        this.expireDate = expireDate;
    }

    public void setValidUntil(LocalDate validUntil) {
        this.validUntil = validUntil;
    }

    @Override
    public void setPsuDataList(List<PsuData> psuDataList) {
        this.psuDataList = psuDataList;
    }

    public void setTppInfo(TppInfoEntity tppInfo) {
        this.tppInfo = tppInfo;
    }

    public void setAuthorisationTemplate(AuthorisationTemplateEntity authorisationTemplate) {
        this.authorisationTemplate = authorisationTemplate;
    }

    public void setTppNotificationUri(String tppNotificationUri) {
        this.tppNotificationUri = tppNotificationUri;
    }

    public void setTppNotificationContentPreferred(List<NotificationSupportedMode> tppNotificationContentPreferred) {
        this.tppNotificationContentPreferred = tppNotificationContentPreferred;
    }

    public void setConsentStatus(ConsentStatus consentStatus) {
        this.consentStatus = consentStatus;
    }

    public void setConsentType(ConsentType consentType) {
        this.consentType = consentType;
    }

    public void setAllowedFrequencyPerDay(int allowedFrequencyPerDay) {
        this.allowedFrequencyPerDay = allowedFrequencyPerDay;
    }

    public void setTppFrequencyPerDay(int tppFrequencyPerDay) {
        this.tppFrequencyPerDay = tppFrequencyPerDay;
    }

    public void setUsages(List<AisConsentUsage> usages) {
        this.usages = usages;
    }

    public void setAccesses(List<TppAccountAccess> accesses) {
        this.accesses = accesses;
    }

    public void setAspspAccountAccesses(List<AspspAccountAccess> aspspAccountAccesses) {
        this.aspspAccountAccesses = aspspAccountAccesses;
    }

    public void setAisConsentRequestType(AisConsentRequestType aisConsentRequestType) {
        this.aisConsentRequestType = aisConsentRequestType;
    }

    public void setCreationTimestamp(OffsetDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public void setAvailableAccounts(AccountAccessType availableAccounts) {
        this.availableAccounts = availableAccounts;
    }

    public void setAllPsd2(AccountAccessType allPsd2) {
        this.allPsd2 = allPsd2;
    }

    public void setAvailableAccountsWithBalance(AccountAccessType availableAccountsWithBalance) {
        this.availableAccountsWithBalance = availableAccountsWithBalance;
    }

    public void setMultilevelScaRequired(boolean multilevelScaRequired) {
        this.multilevelScaRequired = multilevelScaRequired;
    }

    public void setStatusChangeTimestamp(OffsetDateTime statusChangeTimestamp) {
        this.statusChangeTimestamp = statusChangeTimestamp;
    }

    public void setOwnerNameType(AdditionalAccountInformationType ownerNameType) {
        this.ownerNameType = ownerNameType;
    }

    public void setInternalRequestId(String internalRequestId) {
        this.internalRequestId = internalRequestId;
    }

    public void setChecksum(byte[] checksum) {
        this.checksum = checksum;
    }

    public void setPreviousConsentStatus(ConsentStatus previousConsentStatus) {
        this.previousConsentStatus = previousConsentStatus;
    }

    public String toString() {
        return "AisConsent(id=" + this.getId() + ", externalId=" + this.getExternalId() + ", recurringIndicator=" + this.isRecurringIndicator() + ", tppRedirectPreferred=" + this.isTppRedirectPreferred() + ", combinedServiceIndicator=" + this.isCombinedServiceIndicator() + ", requestDateTime=" + this.getRequestDateTime() + ", lastActionDate=" + this.getLastActionDate() + ", expireDate=" + this.getExpireDate() + ", validUntil=" + this.getValidUntil() + ", psuDataList=" + this.getPsuDataList() + ", tppInfo=" + this.getTppInfo() + ", authorisationTemplate=" + this.getAuthorisationTemplate() + ", tppNotificationUri=" + this.getTppNotificationUri() + ", tppNotificationContentPreferred=" + this.getTppNotificationContentPreferred() + ", consentStatus=" + this.getConsentStatus() + ", consentType=" + this.getConsentType() + ", allowedFrequencyPerDay=" + this.getAllowedFrequencyPerDay() + ", tppFrequencyPerDay=" + this.getTppFrequencyPerDay() + ", aspspAccountAccesses=" + this.getAspspAccountAccesses() + ", aisConsentRequestType=" + this.getAisConsentRequestType() + ", creationTimestamp=" + this.getCreationTimestamp() + ", availableAccounts=" + this.getAvailableAccounts() + ", allPsd2=" + this.getAllPsd2() + ", availableAccountsWithBalance=" + this.getAvailableAccountsWithBalance() + ", multilevelScaRequired=" + this.isMultilevelScaRequired() + ", statusChangeTimestamp=" + this.getStatusChangeTimestamp() + ", ownerNameType=" + this.getOwnerNameType() + ", internalRequestId=" + this.getInternalRequestId() + ", checksum=" + Arrays.toString(this.getChecksum()) + ", previousConsentStatus=" + this.getPreviousConsentStatus() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AisConsent)) {
            return false;
        }
        AisConsent other = (AisConsent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$externalId = this.getExternalId();
        String other$externalId = other.getExternalId();
        if (this$externalId == null ? other$externalId != null : !this$externalId.equals(other$externalId)) {
            return false;
        }
        if (this.isRecurringIndicator() != other.isRecurringIndicator()) {
            return false;
        }
        if (this.isTppRedirectPreferred() != other.isTppRedirectPreferred()) {
            return false;
        }
        if (this.isCombinedServiceIndicator() != other.isCombinedServiceIndicator()) {
            return false;
        }
        LocalDateTime this$requestDateTime = this.getRequestDateTime();
        LocalDateTime other$requestDateTime = other.getRequestDateTime();
        if (this$requestDateTime == null ? other$requestDateTime != null : !((Object)this$requestDateTime).equals(other$requestDateTime)) {
            return false;
        }
        LocalDate this$lastActionDate = this.getLastActionDate();
        LocalDate other$lastActionDate = other.getLastActionDate();
        if (this$lastActionDate == null ? other$lastActionDate != null : !((Object)this$lastActionDate).equals(other$lastActionDate)) {
            return false;
        }
        LocalDate this$expireDate = this.getExpireDate();
        LocalDate other$expireDate = other.getExpireDate();
        if (this$expireDate == null ? other$expireDate != null : !((Object)this$expireDate).equals(other$expireDate)) {
            return false;
        }
        LocalDate this$validUntil = this.getValidUntil();
        LocalDate other$validUntil = other.getValidUntil();
        if (this$validUntil == null ? other$validUntil != null : !((Object)this$validUntil).equals(other$validUntil)) {
            return false;
        }
        List<PsuData> this$psuDataList = this.getPsuDataList();
        List<PsuData> other$psuDataList = other.getPsuDataList();
        if (this$psuDataList == null ? other$psuDataList != null : !((Object)this$psuDataList).equals(other$psuDataList)) {
            return false;
        }
        TppInfoEntity this$tppInfo = this.getTppInfo();
        TppInfoEntity other$tppInfo = other.getTppInfo();
        if (this$tppInfo == null ? other$tppInfo != null : !((Object)this$tppInfo).equals(other$tppInfo)) {
            return false;
        }
        AuthorisationTemplateEntity this$authorisationTemplate = this.getAuthorisationTemplate();
        AuthorisationTemplateEntity other$authorisationTemplate = other.getAuthorisationTemplate();
        if (this$authorisationTemplate == null ? other$authorisationTemplate != null : !((Object)this$authorisationTemplate).equals(other$authorisationTemplate)) {
            return false;
        }
        String this$tppNotificationUri = this.getTppNotificationUri();
        String other$tppNotificationUri = other.getTppNotificationUri();
        if (this$tppNotificationUri == null ? other$tppNotificationUri != null : !this$tppNotificationUri.equals(other$tppNotificationUri)) {
            return false;
        }
        List<NotificationSupportedMode> this$tppNotificationContentPreferred = this.getTppNotificationContentPreferred();
        List<NotificationSupportedMode> other$tppNotificationContentPreferred = other.getTppNotificationContentPreferred();
        if (this$tppNotificationContentPreferred == null ? other$tppNotificationContentPreferred != null : !((Object)this$tppNotificationContentPreferred).equals(other$tppNotificationContentPreferred)) {
            return false;
        }
        ConsentStatus this$consentStatus = this.getConsentStatus();
        ConsentStatus other$consentStatus = other.getConsentStatus();
        if (this$consentStatus == null ? other$consentStatus != null : !this$consentStatus.equals(other$consentStatus)) {
            return false;
        }
        ConsentType this$consentType = this.getConsentType();
        ConsentType other$consentType = other.getConsentType();
        if (this$consentType == null ? other$consentType != null : !this$consentType.equals(other$consentType)) {
            return false;
        }
        if (this.getAllowedFrequencyPerDay() != other.getAllowedFrequencyPerDay()) {
            return false;
        }
        if (this.getTppFrequencyPerDay() != other.getTppFrequencyPerDay()) {
            return false;
        }
        List<AisConsentUsage> this$usages = this.getUsages();
        List<AisConsentUsage> other$usages = other.getUsages();
        if (this$usages == null ? other$usages != null : !((Object)this$usages).equals(other$usages)) {
            return false;
        }
        List<TppAccountAccess> this$accesses = this.getAccesses();
        List<TppAccountAccess> other$accesses = other.getAccesses();
        if (this$accesses == null ? other$accesses != null : !((Object)this$accesses).equals(other$accesses)) {
            return false;
        }
        List<AspspAccountAccess> this$aspspAccountAccesses = this.getAspspAccountAccesses();
        List<AspspAccountAccess> other$aspspAccountAccesses = other.getAspspAccountAccesses();
        if (this$aspspAccountAccesses == null ? other$aspspAccountAccesses != null : !((Object)this$aspspAccountAccesses).equals(other$aspspAccountAccesses)) {
            return false;
        }
        AisConsentRequestType this$aisConsentRequestType = this.getAisConsentRequestType();
        AisConsentRequestType other$aisConsentRequestType = other.getAisConsentRequestType();
        if (this$aisConsentRequestType == null ? other$aisConsentRequestType != null : !this$aisConsentRequestType.equals(other$aisConsentRequestType)) {
            return false;
        }
        OffsetDateTime this$creationTimestamp = this.getCreationTimestamp();
        OffsetDateTime other$creationTimestamp = other.getCreationTimestamp();
        if (this$creationTimestamp == null ? other$creationTimestamp != null : !((Object)this$creationTimestamp).equals(other$creationTimestamp)) {
            return false;
        }
        AccountAccessType this$availableAccounts = this.getAvailableAccounts();
        AccountAccessType other$availableAccounts = other.getAvailableAccounts();
        if (this$availableAccounts == null ? other$availableAccounts != null : !this$availableAccounts.equals(other$availableAccounts)) {
            return false;
        }
        AccountAccessType this$allPsd2 = this.getAllPsd2();
        AccountAccessType other$allPsd2 = other.getAllPsd2();
        if (this$allPsd2 == null ? other$allPsd2 != null : !this$allPsd2.equals(other$allPsd2)) {
            return false;
        }
        AccountAccessType this$availableAccountsWithBalance = this.getAvailableAccountsWithBalance();
        AccountAccessType other$availableAccountsWithBalance = other.getAvailableAccountsWithBalance();
        if (this$availableAccountsWithBalance == null ? other$availableAccountsWithBalance != null : !this$availableAccountsWithBalance.equals(other$availableAccountsWithBalance)) {
            return false;
        }
        if (this.isMultilevelScaRequired() != other.isMultilevelScaRequired()) {
            return false;
        }
        OffsetDateTime this$statusChangeTimestamp = this.getStatusChangeTimestamp();
        OffsetDateTime other$statusChangeTimestamp = other.getStatusChangeTimestamp();
        if (this$statusChangeTimestamp == null ? other$statusChangeTimestamp != null : !((Object)this$statusChangeTimestamp).equals(other$statusChangeTimestamp)) {
            return false;
        }
        AdditionalAccountInformationType this$ownerNameType = this.getOwnerNameType();
        AdditionalAccountInformationType other$ownerNameType = other.getOwnerNameType();
        if (this$ownerNameType == null ? other$ownerNameType != null : !this$ownerNameType.equals(other$ownerNameType)) {
            return false;
        }
        String this$internalRequestId = this.getInternalRequestId();
        String other$internalRequestId = other.getInternalRequestId();
        if (this$internalRequestId == null ? other$internalRequestId != null : !this$internalRequestId.equals(other$internalRequestId)) {
            return false;
        }
        if (!Arrays.equals(this.getChecksum(), other.getChecksum())) {
            return false;
        }
        ConsentStatus this$previousConsentStatus = this.getPreviousConsentStatus();
        ConsentStatus other$previousConsentStatus = other.getPreviousConsentStatus();
        return !(this$previousConsentStatus == null ? other$previousConsentStatus != null : !this$previousConsentStatus.equals(other$previousConsentStatus));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AisConsent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $externalId = this.getExternalId();
        result = result * 59 + ($externalId == null ? 43 : $externalId.hashCode());
        result = result * 59 + (this.isRecurringIndicator() ? 79 : 97);
        result = result * 59 + (this.isTppRedirectPreferred() ? 79 : 97);
        result = result * 59 + (this.isCombinedServiceIndicator() ? 79 : 97);
        LocalDateTime $requestDateTime = this.getRequestDateTime();
        result = result * 59 + ($requestDateTime == null ? 43 : ((Object)$requestDateTime).hashCode());
        LocalDate $lastActionDate = this.getLastActionDate();
        result = result * 59 + ($lastActionDate == null ? 43 : ((Object)$lastActionDate).hashCode());
        LocalDate $expireDate = this.getExpireDate();
        result = result * 59 + ($expireDate == null ? 43 : ((Object)$expireDate).hashCode());
        LocalDate $validUntil = this.getValidUntil();
        result = result * 59 + ($validUntil == null ? 43 : ((Object)$validUntil).hashCode());
        List<PsuData> $psuDataList = this.getPsuDataList();
        result = result * 59 + ($psuDataList == null ? 43 : ((Object)$psuDataList).hashCode());
        TppInfoEntity $tppInfo = this.getTppInfo();
        result = result * 59 + ($tppInfo == null ? 43 : ((Object)$tppInfo).hashCode());
        AuthorisationTemplateEntity $authorisationTemplate = this.getAuthorisationTemplate();
        result = result * 59 + ($authorisationTemplate == null ? 43 : ((Object)$authorisationTemplate).hashCode());
        String $tppNotificationUri = this.getTppNotificationUri();
        result = result * 59 + ($tppNotificationUri == null ? 43 : $tppNotificationUri.hashCode());
        List<NotificationSupportedMode> $tppNotificationContentPreferred = this.getTppNotificationContentPreferred();
        result = result * 59 + ($tppNotificationContentPreferred == null ? 43 : ((Object)$tppNotificationContentPreferred).hashCode());
        ConsentStatus $consentStatus = this.getConsentStatus();
        result = result * 59 + ($consentStatus == null ? 43 : $consentStatus.hashCode());
        ConsentType $consentType = this.getConsentType();
        result = result * 59 + ($consentType == null ? 43 : $consentType.hashCode());
        result = result * 59 + this.getAllowedFrequencyPerDay();
        result = result * 59 + this.getTppFrequencyPerDay();
        List<AisConsentUsage> $usages = this.getUsages();
        result = result * 59 + ($usages == null ? 43 : ((Object)$usages).hashCode());
        List<TppAccountAccess> $accesses = this.getAccesses();
        result = result * 59 + ($accesses == null ? 43 : ((Object)$accesses).hashCode());
        List<AspspAccountAccess> $aspspAccountAccesses = this.getAspspAccountAccesses();
        result = result * 59 + ($aspspAccountAccesses == null ? 43 : ((Object)$aspspAccountAccesses).hashCode());
        AisConsentRequestType $aisConsentRequestType = this.getAisConsentRequestType();
        result = result * 59 + ($aisConsentRequestType == null ? 43 : $aisConsentRequestType.hashCode());
        OffsetDateTime $creationTimestamp = this.getCreationTimestamp();
        result = result * 59 + ($creationTimestamp == null ? 43 : ((Object)$creationTimestamp).hashCode());
        AccountAccessType $availableAccounts = this.getAvailableAccounts();
        result = result * 59 + ($availableAccounts == null ? 43 : $availableAccounts.hashCode());
        AccountAccessType $allPsd2 = this.getAllPsd2();
        result = result * 59 + ($allPsd2 == null ? 43 : $allPsd2.hashCode());
        AccountAccessType $availableAccountsWithBalance = this.getAvailableAccountsWithBalance();
        result = result * 59 + ($availableAccountsWithBalance == null ? 43 : $availableAccountsWithBalance.hashCode());
        result = result * 59 + (this.isMultilevelScaRequired() ? 79 : 97);
        OffsetDateTime $statusChangeTimestamp = this.getStatusChangeTimestamp();
        result = result * 59 + ($statusChangeTimestamp == null ? 43 : ((Object)$statusChangeTimestamp).hashCode());
        AdditionalAccountInformationType $ownerNameType = this.getOwnerNameType();
        result = result * 59 + ($ownerNameType == null ? 43 : $ownerNameType.hashCode());
        String $internalRequestId = this.getInternalRequestId();
        result = result * 59 + ($internalRequestId == null ? 43 : $internalRequestId.hashCode());
        result = result * 59 + Arrays.hashCode(this.getChecksum());
        ConsentStatus $previousConsentStatus = this.getPreviousConsentStatus();
        result = result * 59 + ($previousConsentStatus == null ? 43 : $previousConsentStatus.hashCode());
        return result;
    }
}

