/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.aspsp.profile.service.AspspProfileService;
import de.adorsys.psd2.consent.domain.AuthorisationEntity;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.consent.repository.AuthorisationRepository;
import de.adorsys.psd2.consent.service.AisConsentConfirmationExpirationService;
import de.adorsys.psd2.xs2a.core.authorisation.AuthorisationType;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IterableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AisConsentConfirmationExpirationServiceImpl
implements AisConsentConfirmationExpirationService {
    private static final Logger log = LoggerFactory.getLogger(AisConsentConfirmationExpirationServiceImpl.class);
    private final AisConsentJpaRepository aisConsentJpaRepository;
    private final AuthorisationRepository authorisationRepository;
    private final AspspProfileService aspspProfileService;

    @Override
    @Transactional
    public AisConsent checkAndUpdateOnConfirmationExpiration(AisConsent consent) {
        if (this.isConfirmationExpired(consent)) {
            log.info("Consent ID: [{}]. Consent is expired", (Object)consent.getExternalId());
            return this.updateOnConfirmationExpiration(consent);
        }
        return consent;
    }

    @Override
    public boolean isConfirmationExpired(AisConsent consent) {
        long expirationPeriodMs = this.aspspProfileService.getAspspSettings().getAis().getConsentTypes().getNotConfirmedConsentExpirationTimeMs();
        return consent != null && consent.isConfirmationExpired(expirationPeriodMs);
    }

    @Override
    @Transactional
    public AisConsent expireConsent(AisConsent consent) {
        LocalDate now = LocalDate.now();
        consent.setConsentStatus(ConsentStatus.EXPIRED);
        consent.setExpireDate(now);
        consent.setLastActionDate(now);
        return (AisConsent)this.aisConsentJpaRepository.save(consent);
    }

    @Override
    @Transactional
    public AisConsent updateOnConfirmationExpiration(AisConsent consent) {
        return (AisConsent)this.aisConsentJpaRepository.save(this.obsoleteConsent(consent));
    }

    @Override
    @Transactional
    public List<AisConsent> updateConsentListOnConfirmationExpiration(List<AisConsent> consents) {
        return IterableUtils.toList((Iterable)this.aisConsentJpaRepository.saveAll(this.obsoleteConsentList(consents)));
    }

    private List<AisConsent> obsoleteConsentList(List<AisConsent> consents) {
        return consents.stream().map(this::obsoleteConsent).collect(Collectors.toList());
    }

    private AisConsent obsoleteConsent(AisConsent consent) {
        consent.setConsentStatus(ConsentStatus.REJECTED);
        List<AuthorisationEntity> authorisations = this.authorisationRepository.findAllByParentExternalIdAndAuthorisationType(consent.getExternalId(), AuthorisationType.AIS);
        authorisations.forEach(auth -> auth.setScaStatus(ScaStatus.FAILED));
        this.authorisationRepository.saveAll(authorisations);
        consent.setLastActionDate(LocalDate.now());
        return consent;
    }

    @ConstructorProperties(value={"aisConsentJpaRepository", "authorisationRepository", "aspspProfileService"})
    public AisConsentConfirmationExpirationServiceImpl(AisConsentJpaRepository aisConsentJpaRepository, AuthorisationRepository authorisationRepository, AspspProfileService aspspProfileService) {
        this.aisConsentJpaRepository = aisConsentJpaRepository;
        this.authorisationRepository = authorisationRepository;
        this.aspspProfileService = aspspProfileService;
    }
}

