/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.domain.payment.PisCommonPaymentData;
import de.adorsys.psd2.consent.repository.PisCommonPaymentDataRepository;
import de.adorsys.psd2.consent.repository.specification.PisCommonPaymentDataSpecification;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CommonPaymentDataService {
    private final PisCommonPaymentDataRepository pisCommonPaymentDataRepository;
    private final PisCommonPaymentDataSpecification pisCommonPaymentDataSpecification;

    public Optional<PisCommonPaymentData> getPisCommonPaymentData(String paymentId, @Nullable String instanceId) {
        Specification specification = Optional.ofNullable(instanceId).map(i -> this.pisCommonPaymentDataSpecification.byPaymentIdAndInstanceId(paymentId, (String)i)).orElseGet(() -> this.pisCommonPaymentDataSpecification.byPaymentId(paymentId));
        return this.pisCommonPaymentDataRepository.findOne(specification);
    }

    @Transactional
    public boolean updateStatusInPaymentData(PisCommonPaymentData paymentData, TransactionStatus status) {
        PisCommonPaymentData saved;
        paymentData.setTransactionStatus(status);
        if (status == TransactionStatus.PATC) {
            paymentData.setMultilevelScaRequired(true);
        }
        return (saved = (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(paymentData)).getPaymentId() != null;
    }

    @Transactional
    public boolean updateCancelTppRedirectURIs(PisCommonPaymentData paymentData, @NotNull TppRedirectUri tppRedirectUri) {
        paymentData.getAuthorisationTemplate().setCancelRedirectUri(tppRedirectUri.getUri());
        paymentData.getAuthorisationTemplate().setCancelNokRedirectUri(tppRedirectUri.getNokUri());
        PisCommonPaymentData saved = (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(paymentData);
        return saved.getPaymentId() != null;
    }

    @Transactional
    public boolean updatePaymentCancellationInternalRequestId(PisCommonPaymentData paymentData, @NotNull String internalRequestId) {
        paymentData.setCancellationInternalRequestId(internalRequestId);
        PisCommonPaymentData saved = (PisCommonPaymentData)this.pisCommonPaymentDataRepository.save(paymentData);
        return saved.getPaymentId() != null;
    }

    @ConstructorProperties(value={"pisCommonPaymentDataRepository", "pisCommonPaymentDataSpecification"})
    public CommonPaymentDataService(PisCommonPaymentDataRepository pisCommonPaymentDataRepository, PisCommonPaymentDataSpecification pisCommonPaymentDataSpecification) {
        this.pisCommonPaymentDataRepository = pisCommonPaymentDataRepository;
        this.pisCommonPaymentDataSpecification = pisCommonPaymentDataSpecification;
    }
}

