/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.aspsp;

import de.adorsys.psd2.consent.aspsp.api.psu.CmsAspspPsuAccountService;
import de.adorsys.psd2.consent.domain.account.AisConsent;
import de.adorsys.psd2.consent.domain.piis.PiisConsentEntity;
import de.adorsys.psd2.consent.repository.AisConsentJpaRepository;
import de.adorsys.psd2.consent.repository.PiisConsentRepository;
import de.adorsys.psd2.consent.repository.specification.AisConsentSpecification;
import de.adorsys.psd2.consent.repository.specification.PiisConsentEntitySpecification;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CmsAspspPsuAccountServiceInternal
implements CmsAspspPsuAccountService {
    private final AisConsentSpecification aisConsentSpecification;
    private final AisConsentJpaRepository aisConsentJpaRepository;
    private final PiisConsentRepository piisConsentRepository;
    private final PiisConsentEntitySpecification piisConsentEntitySpecification;

    @Transactional
    public boolean revokeAllConsents(@Nullable String aspspAccountId, @NotNull PsuIdData psuIdData, @Nullable String instanceId) {
        List aisConsents = this.aisConsentJpaRepository.findAll(this.aisConsentSpecification.byAspspAccountIdAndPsuIdDataAndInstanceId(aspspAccountId, psuIdData, instanceId));
        List piisConsents = this.piisConsentRepository.findAll(this.piisConsentEntitySpecification.byAspspAccountIdAndPsuIdDataAndInstanceId(aspspAccountId, psuIdData, instanceId));
        List<AisConsent> filteredAisConsents = aisConsents.stream().filter(cst -> !cst.getConsentStatus().isFinalisedStatus()).collect(Collectors.toList());
        List<PiisConsentEntity> filteredPiisConsents = piisConsents.stream().filter(cst -> !cst.getConsentStatus().isFinalisedStatus()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredAisConsents) && CollectionUtils.isEmpty(filteredPiisConsents)) {
            return false;
        }
        filteredAisConsents.forEach(cst -> {
            cst.setLastActionDate(LocalDate.now());
            cst.setConsentStatus(ConsentStatus.REVOKED_BY_PSU);
            this.aisConsentJpaRepository.save(cst);
        });
        filteredPiisConsents.forEach(cst -> {
            cst.setLastActionDate(LocalDate.now());
            cst.setConsentStatus(ConsentStatus.REVOKED_BY_PSU);
            this.piisConsentRepository.save(cst);
        });
        return true;
    }

    @ConstructorProperties(value={"aisConsentSpecification", "aisConsentJpaRepository", "piisConsentRepository", "piisConsentEntitySpecification"})
    public CmsAspspPsuAccountServiceInternal(AisConsentSpecification aisConsentSpecification, AisConsentJpaRepository aisConsentJpaRepository, PiisConsentRepository piisConsentRepository, PiisConsentEntitySpecification piisConsentEntitySpecification) {
        this.aisConsentSpecification = aisConsentSpecification;
        this.aisConsentJpaRepository = aisConsentJpaRepository;
        this.piisConsentRepository = piisConsentRepository;
        this.piisConsentEntitySpecification = piisConsentEntitySpecification;
    }
}

