/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service.security.provider.jwe;

import de.adorsys.psd2.consent.service.security.provider.CryptoInstanceFactory;
import de.adorsys.psd2.consent.service.security.provider.CryptoProvider;
import de.adorsys.psd2.consent.service.security.provider.jwe.JweCryptoProviderImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JweGsmInstanceFactoryImpl
implements CryptoInstanceFactory {
    private static final Logger log = LoggerFactory.getLogger(JweGsmInstanceFactoryImpl.class);
    private static final String SEPARATOR = "_#_";

    @Override
    public CryptoProvider initProvider(String cryptoProviderId, String parameters) throws IllegalArgumentException {
        String[] paramsArr = StringUtils.split((String)parameters, (String)SEPARATOR);
        int keyLength = this.getIntegerValueByIndex(paramsArr, 2, 256);
        int hashIterations = this.getIntegerValueByIndex(paramsArr, 3, 65536);
        String skfAlgorithm = this.getStringValueByIndex(paramsArr, 4, "PBKDF2WithHmacSHA256");
        return new JweCryptoProviderImpl(cryptoProviderId, keyLength, hashIterations, skfAlgorithm);
    }

    private String getStringValueByIndex(String[] paramsArr, int index, String defaultValue) {
        if (paramsArr == null) {
            return defaultValue;
        }
        if (paramsArr.length > index) {
            return paramsArr[index];
        }
        return defaultValue;
    }

    private Integer getIntegerValueByIndex(String[] paramsArr, int index, Integer defaultValue) {
        if (paramsArr == null) {
            return defaultValue;
        }
        if (paramsArr.length > index) {
            return Integer.valueOf(paramsArr[index]);
        }
        return defaultValue;
    }
}

