/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AisConsentRemoteUrls {
    @Value(value="${consent-service.baseurl:http://localhost:38080/api/v1}")
    private String consentServiceBaseUrl;

    public String createAisConsent() {
        return this.consentServiceBaseUrl + "/ais/consent/";
    }

    public String getAisConsentById() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}";
    }

    public String getInitialAisConsentById() {
        return this.consentServiceBaseUrl + "/ais/consent/initial/{consent-id}";
    }

    public String getAisConsentStatusById() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/status";
    }

    public String updateAisConsentStatus() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/status/{status}";
    }

    public String findAndTerminateOldConsentsByNewConsentId() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/old-consents";
    }

    public String consentActionLog() {
        return this.consentServiceBaseUrl + "/ais/consent/action";
    }

    public String createAisConsentAuthorization() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/authorizations";
    }

    public String updateAisConsentAuthorization() {
        return this.consentServiceBaseUrl + "/ais/consent/authorizations/{authorization-id}";
    }

    public String updateAisConsentAuthorisationStatus() {
        return this.consentServiceBaseUrl + "/ais/consent/authorisations/{authorisation-id}/status/{status}";
    }

    public String getAisConsentAuthorizationById() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/authorizations/{authorization-id}";
    }

    public String updateAisAccountAccess() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/access";
    }

    public String getPsuDataByConsentId() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/psu-data";
    }

    public String getAuthorisationSubResources() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/authorisations";
    }

    public String getAuthorisationScaStatus() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/authorisations/{authorisation-id}/status";
    }

    public String isAuthenticationMethodDecoupled() {
        return this.consentServiceBaseUrl + "/ais/consent/authorisations/{authorisation-id}/authentication-methods/{authentication-method-id}";
    }

    public String saveAuthenticationMethods() {
        return this.consentServiceBaseUrl + "/ais/consent/authorisations/{authorisation-id}/authentication-methods";
    }

    public String updateScaApproach() {
        return this.consentServiceBaseUrl + "/ais/consent/authorisations/{authorisation-id}/sca-approach/{sca-approach}";
    }

    public String updateMultilevelScaRequired() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/multilevel-sca?multilevel-sca={multilevel-sca}";
    }

    public String getAuthorisationScaApproach() {
        return this.consentServiceBaseUrl + "/ais/consent/authorisations/{authorisation-id}/sca-approach";
    }

    public String saveNumberOfTransactions() {
        return this.consentServiceBaseUrl + "/ais/consent/{consent-id}/{resource-id}";
    }
}

