/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AuthorisationRemoteUrls {
    @Value(value="${consent-service.baseurl:http://localhost:38080/api/v1}")
    private String consentServiceBaseUrl;

    public String createAuthorisation() {
        return this.consentServiceBaseUrl + "/{authorisation-type}/{parent-id}/authorisations";
    }

    public String getAuthorisationById() {
        return this.consentServiceBaseUrl + "/authorisations/{authorisation-id}";
    }

    public String updateAuthorisation() {
        return this.consentServiceBaseUrl + "/authorisations/{authorisation-id}";
    }

    public String getAuthorisationsByParentId() {
        return this.consentServiceBaseUrl + "/{authorisation-type}/{parent-id}/authorisations";
    }

    public String getAuthorisationScaStatus() {
        return this.consentServiceBaseUrl + "/{authorisation-type}/{parent-id}/authorisations/{authorisation-id}/status";
    }

    public String updateAuthorisationStatus() {
        return this.consentServiceBaseUrl + "/authorisations/{authorisation-id}/status/{status}";
    }

    public String isAuthenticationMethodDecoupled() {
        return this.consentServiceBaseUrl + "/authorisations/{authorisation-id}/authentication-methods/{authentication-method-id}";
    }

    public String saveAuthenticationMethods() {
        return this.consentServiceBaseUrl + "/authorisations/{authorisation-id}/authentication-methods";
    }

    public String updateScaApproach() {
        return this.consentServiceBaseUrl + "/authorisations/{authorisation-id}/sca-approach/{sca-approach}";
    }

    public String getAuthorisationScaApproach() {
        return this.consentServiceBaseUrl + "/authorisations/{authorisation-id}/sca-approach";
    }
}

