/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.config;

import de.adorsys.psd2.consent.config.ConsentRestErrorHandler;
import de.adorsys.psd2.logger.web.LoggingContextInterceptor;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ConsentRestConfig {
    private final LoggingContextInterceptor loggingContextInterceptor;
    @Value(value="${rest-consent-config.read-timeout.ms:10000}")
    private int readTimeout;
    @Value(value="${rest-consent-config.connection-timeout.ms:10000}")
    private int connectionTimeout;

    @Bean
    public RestTemplate consentRestTemplate() {
        RestTemplate rest = new RestTemplate(this.clientHttpRequestFactory());
        rest.getMessageConverters().removeIf(m -> m.getClass().isAssignableFrom(MappingJackson2XmlHttpMessageConverter.class));
        rest.setErrorHandler((ResponseErrorHandler)new ConsentRestErrorHandler());
        rest.getInterceptors().add(this.loggingContextInterceptor);
        return rest;
    }

    private ClientHttpRequestFactory clientHttpRequestFactory() {
        SimpleClientHttpRequestFactory factory = new SimpleClientHttpRequestFactory();
        factory.setReadTimeout(this.readTimeout);
        factory.setConnectTimeout(this.connectionTimeout);
        return factory;
    }

    @ConstructorProperties(value={"loggingContextInterceptor"})
    public ConsentRestConfig(LoggingContextInterceptor loggingContextInterceptor) {
        this.loggingContextInterceptor = loggingContextInterceptor;
    }
}

