/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.config;

import de.adorsys.psd2.consent.config.CmsRestException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class ConsentRestErrorHandler
extends DefaultResponseErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ConsentRestErrorHandler.class);

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = response.getStatusCode();
        byte[] textInBytes = new byte[]{};
        try {
            InputStream responseBody = response.getBody();
            textInBytes = FileCopyUtils.copyToByteArray((InputStream)responseBody);
        }
        catch (IOException ex) {
            log.error("Error during handling REST error from CMS.");
        }
        if (statusCode.value() == 404) {
            throw new CmsRestException(statusCode);
        }
        throw new CmsRestException(statusCode, new String(textInBytes).replaceAll("\"", ""));
    }
}

