/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PisCommonPaymentRemoteUrls {
    @Value(value="${consent-service.baseurl:http://localhost:38080/api/v1}")
    private String commonPaymentServiceBaseUrl;

    public String createPisCommonPayment() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/";
    }

    public String updatePisCommonPaymentStatus() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{paymentId}/status/{status}";
    }

    public String getPisCommonPaymentStatusById() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{paymentId}/status";
    }

    public String getPisCommonPaymentById() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{paymentId}";
    }

    public String createPisAuthorisation() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{payment-id}/authorizations";
    }

    public String createPisAuthorisationCancellation() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{payment-id}/cancellation-authorisations";
    }

    public String getCancellationAuthorisationSubResources() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{payment-id}/cancellation-authorisations";
    }

    public String updatePisAuthorisation() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/authorizations/{authorization-id}";
    }

    public String updatePisAuthorisationStatus() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/authorisations/{authorisation-id}/status/{status}";
    }

    public String updatePisCancellationAuthorisation() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/cancellation-authorisations/{cancellation-id}";
    }

    public String getPisAuthorisationById() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/authorizations/{authorization-id}";
    }

    public String getPisCancellationAuthorisationById() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/cancellation-authorisations/{cancellation-id}";
    }

    public String getPaymentIdByEncryptedString() {
        return this.commonPaymentServiceBaseUrl + "/pis/payment/{payment-id}";
    }

    public String updatePisCommonPayment() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{consent-id}/payment";
    }

    public String getPsuDataByCommonPaymentId() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{consent-id}/psu-data";
    }

    public String getPsuDataByPaymentId() {
        return this.commonPaymentServiceBaseUrl + "/pis/payment/{payment-id}/psu-data";
    }

    public String getAuthorisationSubResources() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{payment-id}/authorisations";
    }

    public String getAuthorisationScaStatus() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{payment-id}/authorisations/{authorisation-id}/status";
    }

    public String getCancellationAuthorisationScaStatus() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{payment-id}/cancellation-authorisations/{cancellation-id}/status";
    }

    public String isAuthenticationMethodDecoupled() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/authorisations/{authorisation-id}/authentication-methods/{authentication-method-id}";
    }

    public String saveAuthenticationMethods() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/authorisations/{authorisation-id}/authentication-methods";
    }

    public String updateScaApproach() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/authorisations/{authorisation-id}/sca-approach/{sca-approach}";
    }

    public String getAuthorisationScaApproach() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/authorisations/{authorisation-id}/sca-approach";
    }

    public String getCancellationAuthorisationScaApproach() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/cancellation-authorisations/{authorisation-id}/sca-approach";
    }

    public String updateMultilevelScaRequired() {
        return this.commonPaymentServiceBaseUrl + "/pis/common-payments/{payment-id}/multilevel-sca?multilevel-sca={multilevel-sca}";
    }
}

