/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.service.AccountServiceEncrypted;
import de.adorsys.psd2.consent.config.AisConsentRemoteUrls;
import de.adorsys.psd2.consent.config.CmsRestException;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AccountServiceRemote
implements AccountServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceRemote.class);
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final AisConsentRemoteUrls remoteAisConsentUrls;

    public boolean saveNumberOfTransactions(String consentId, String resourceId, int numberOfTransactions) {
        try {
            return (Boolean)this.consentRestTemplate.exchange(this.remoteAisConsentUrls.saveNumberOfTransactions(), HttpMethod.PUT, new HttpEntity((Object)numberOfTransactions), Boolean.class, new Object[]{consentId, resourceId}).getBody();
        }
        catch (CmsRestException cmsRestException) {
            log.info("Couldn't save number of transactions to CMS");
            return false;
        }
    }

    @ConstructorProperties(value={"consentRestTemplate", "remoteAisConsentUrls"})
    public AccountServiceRemote(RestTemplate consentRestTemplate, AisConsentRemoteUrls remoteAisConsentUrls) {
        this.consentRestTemplate = consentRestTemplate;
        this.remoteAisConsentUrls = remoteAisConsentUrls;
    }
}

