/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentStatusResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentResponse;
import de.adorsys.psd2.consent.api.ais.UpdateAisConsentResponse;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.config.AisConsentRemoteUrls;
import de.adorsys.psd2.consent.config.CmsRestException;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AisConsentServiceRemote
implements AisConsentServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AisConsentServiceRemote.class);
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final AisConsentRemoteUrls remoteAisConsentUrls;

    public CmsResponse<CreateAisConsentResponse> createConsent(CreateAisConsentRequest request) {
        try {
            ResponseEntity createAisConsentResponse = this.consentRestTemplate.postForEntity(this.remoteAisConsentUrls.createAisConsent(), (Object)request, CreateAisConsentResponse.class, new Object[0]);
            return CmsResponse.builder().payload(createAisConsentResponse.getBody()).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote consent creation failed");
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<ConsentStatus> getConsentStatusById(String consentId) {
        try {
            AisConsentStatusResponse response = (AisConsentStatusResponse)this.consentRestTemplate.getForEntity(this.remoteAisConsentUrls.getAisConsentStatusById(), AisConsentStatusResponse.class, new Object[]{consentId}).getBody();
            if (response != null) {
                return CmsResponse.builder().payload((Object)response.getConsentStatus()).build();
            }
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote get consent status by id failed");
        }
        return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
    }

    public CmsResponse<Boolean> updateConsentStatusById(String consentId, ConsentStatus status) {
        try {
            this.consentRestTemplate.put(this.remoteAisConsentUrls.updateAisConsentStatus(), null, new Object[]{consentId, status});
            return CmsResponse.builder().payload((Object)true).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Cannot update consent status, the consent is already deleted or not found");
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    public CmsResponse<AisAccountConsent> getAisAccountConsentById(String consentId) {
        ResponseEntity accountConsent = this.consentRestTemplate.getForEntity(this.remoteAisConsentUrls.getAisConsentById(), AisAccountConsent.class, new Object[]{consentId});
        if (accountConsent.getStatusCode() == HttpStatus.OK) {
            return CmsResponse.builder().payload(accountConsent.getBody()).build();
        }
        log.warn("Remote get account consent by id failed");
        return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
    }

    public CmsResponse<Boolean> findAndTerminateOldConsentsByNewConsentId(String newConsentId) {
        this.consentRestTemplate.delete(this.remoteAisConsentUrls.findAndTerminateOldConsentsByNewConsentId(), new Object[]{newConsentId});
        return CmsResponse.builder().payload((Object)true).build();
    }

    public CmsResponse<CmsResponse.VoidResponse> checkConsentAndSaveActionLog(AisConsentActionRequest request) {
        this.consentRestTemplate.postForEntity(this.remoteAisConsentUrls.consentActionLog(), (Object)request, Void.class, new Object[0]);
        return CmsResponse.builder().payload((Object)CmsResponse.voidResponse()).build();
    }

    public CmsResponse<String> updateAspspAccountAccess(String consentId, AisAccountAccessInfo request) {
        CreateAisConsentResponse response = (CreateAisConsentResponse)this.consentRestTemplate.exchange(this.remoteAisConsentUrls.updateAisAccountAccess(), HttpMethod.PUT, new HttpEntity((Object)request), CreateAisConsentResponse.class, new Object[]{consentId}).getBody();
        if (response != null) {
            return CmsResponse.builder().payload((Object)response.getConsentId()).build();
        }
        log.warn("Remote update aspsp account access failed");
        return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
    }

    public CmsResponse<AisAccountConsent> updateAspspAccountAccessWithResponse(String consentId, AisAccountAccessInfo request) {
        try {
            UpdateAisConsentResponse response = (UpdateAisConsentResponse)this.consentRestTemplate.exchange(this.remoteAisConsentUrls.updateAisAccountAccess(), HttpMethod.PUT, new HttpEntity((Object)request), UpdateAisConsentResponse.class, new Object[]{consentId}).getBody();
            if (response != null) {
                return CmsResponse.builder().payload((Object)response.getAisConsent()).build();
            }
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote update ASPSP account access with response failed");
            return CmsResponse.builder().error(cmsRestException.getCmsError()).build();
        }
        return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
    }

    public CmsResponse<List<PsuIdData>> getPsuDataByConsentId(String consentId) {
        try {
            List response = (List)this.consentRestTemplate.exchange(this.remoteAisConsentUrls.getPsuDataByConsentId(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<PsuIdData>>(){}, new Object[]{consentId}).getBody();
            return CmsResponse.builder().payload((Object)response).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote get psu data by consent id failed");
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<Boolean> updateMultilevelScaRequired(String encryptedConsentId, boolean multilevelScaRequired) {
        try {
            Boolean updateResponse = (Boolean)this.consentRestTemplate.exchange(this.remoteAisConsentUrls.updateMultilevelScaRequired(), HttpMethod.PUT, null, Boolean.class, new Object[]{encryptedConsentId, multilevelScaRequired}).getBody();
            return CmsResponse.builder().payload((Object)updateResponse).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote update multilevel sca required failed");
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    @ConstructorProperties(value={"consentRestTemplate", "remoteAisConsentUrls"})
    public AisConsentServiceRemote(RestTemplate consentRestTemplate, AisConsentRemoteUrls remoteAisConsentUrls) {
        this.consentRestTemplate = consentRestTemplate;
        this.remoteAisConsentUrls = remoteAisConsentUrls;
    }
}

