/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.AspspDataService;
import de.adorsys.psd2.consent.api.CmsAspspConsentDataBase64;
import de.adorsys.psd2.consent.config.AspspConsentDataRemoteUrls;
import de.adorsys.psd2.consent.config.CmsRestException;
import de.adorsys.psd2.consent.service.Base64AspspDataService;
import de.adorsys.psd2.xs2a.core.consent.AspspConsentData;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AspspDataServiceRemote
implements AspspDataService {
    private static final Logger log = LoggerFactory.getLogger(AspspDataServiceRemote.class);
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final AspspConsentDataRemoteUrls aspspConsentDataRemoteUrls;
    private final Base64AspspDataService base64AspspDataService;

    @NotNull
    public Optional<AspspConsentData> readAspspConsentData(@NotNull String externalId) {
        try {
            ResponseEntity request = this.consentRestTemplate.getForEntity(this.aspspConsentDataRemoteUrls.getAspspConsentData(), CmsAspspConsentDataBase64.class, new Object[]{externalId});
            return Optional.of(request.getBody()).map(this::mapToAspspConsentData);
        }
        catch (CmsRestException e) {
            log.warn("Failed to read AspspConsentData! Consent ID {}", (Object)externalId);
            return Optional.empty();
        }
    }

    public boolean updateAspspConsentData(@NotNull AspspConsentData aspspConsentData) {
        if (aspspConsentData.isEmptyConsentData()) {
            log.warn("Failed to update AspspConsentData. AspspConsentData is empty");
            return false;
        }
        String base64Payload = this.base64AspspDataService.encode(aspspConsentData.getAspspConsentData());
        String consentId = aspspConsentData.getConsentId();
        CmsAspspConsentDataBase64 cmsAspspConsentDataBase64 = new CmsAspspConsentDataBase64(consentId, base64Payload);
        try {
            return this.consentRestTemplate.exchange(this.aspspConsentDataRemoteUrls.updateAspspConsentData(), HttpMethod.PUT, new HttpEntity((Object)cmsAspspConsentDataBase64), Void.class, new Object[]{consentId}).getStatusCode() == HttpStatus.OK;
        }
        catch (CmsRestException e) {
            log.warn("Failed to update AspspConsentData! Consent ID {}", (Object)aspspConsentData.getConsentId());
            return false;
        }
    }

    public boolean deleteAspspConsentData(@NotNull String externalId) {
        try {
            ResponseEntity request = this.consentRestTemplate.exchange(this.aspspConsentDataRemoteUrls.deleteAspspConsentData(), HttpMethod.DELETE, null, Boolean.class, new Object[]{externalId});
            return (Boolean)request.getBody();
        }
        catch (CmsRestException e) {
            log.warn("Failed to delete AspspConsentData! Consent ID {}", (Object)externalId);
            return false;
        }
    }

    private AspspConsentData mapToAspspConsentData(CmsAspspConsentDataBase64 consentData) {
        byte[] bytePayload = this.base64AspspDataService.decode(consentData.getAspspConsentDataBase64());
        return new AspspConsentData(bytePayload, consentData.getConsentId());
    }

    @ConstructorProperties(value={"consentRestTemplate", "aspspConsentDataRemoteUrls", "base64AspspDataService"})
    public AspspDataServiceRemote(RestTemplate consentRestTemplate, AspspConsentDataRemoteUrls aspspConsentDataRemoteUrls, Base64AspspDataService base64AspspDataService) {
        this.consentRestTemplate = consentRestTemplate;
        this.aspspConsentDataRemoteUrls = aspspConsentDataRemoteUrls;
        this.base64AspspDataService = base64AspspDataService;
    }
}

