/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.authorisation.AuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.consent.config.AuthorisationRemoteUrls;
import de.adorsys.psd2.consent.config.CmsRestException;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import java.beans.ConstructorProperties;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AuthorisationServiceRemote
implements AuthorisationServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(AuthorisationServiceRemote.class);
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final AuthorisationRemoteUrls authorisationRemoteUrls;

    public CmsResponse<CreateAuthorisationResponse> createAuthorisation(AuthorisationParentHolder parentHolder, CreateAuthorisationRequest request) {
        try {
            CreateAuthorisationResponse response = (CreateAuthorisationResponse)this.consentRestTemplate.postForEntity(this.authorisationRemoteUrls.createAuthorisation(), (Object)request, CreateAuthorisationResponse.class, new Object[]{parentHolder.getAuthorisationType(), parentHolder.getParentId()}).getBody();
            return CmsResponse.builder().payload((Object)response).build();
        }
        catch (CmsRestException cmsRestException) {
            log.info("Couldn't create new authorisation, HTTP response status: {}", (Object)cmsRestException.getHttpStatus());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<Authorisation> getAuthorisationById(String authorisationId) {
        try {
            Authorisation response = (Authorisation)this.consentRestTemplate.getForEntity(this.authorisationRemoteUrls.getAuthorisationById(), Authorisation.class, new Object[]{authorisationId}).getBody();
            return CmsResponse.builder().payload((Object)response).build();
        }
        catch (CmsRestException cmsRestException) {
            log.info("Couldn't get authorisation by authorisation ID {}, HTTP response status: {}", (Object)authorisationId, (Object)cmsRestException.getHttpStatus());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<Authorisation> updateAuthorisation(String authorisationId, UpdateAuthorisationRequest request) {
        try {
            ResponseEntity responseEntity = this.consentRestTemplate.exchange(this.authorisationRemoteUrls.updateAuthorisation(), HttpMethod.PUT, new HttpEntity((Object)request), Authorisation.class, new Object[]{authorisationId});
            return CmsResponse.builder().payload(responseEntity.getBody()).build();
        }
        catch (CmsRestException cmsRestException) {
            log.info("Couldn't update authorisation by authorisation ID {}, HTTP response status: {}", (Object)authorisationId, (Object)cmsRestException.getHttpStatus());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<Boolean> updateAuthorisationStatus(String authorisationId, ScaStatus scaStatus) {
        try {
            this.consentRestTemplate.put(this.authorisationRemoteUrls.updateAuthorisationStatus(), null, new Object[]{authorisationId, scaStatus});
            return CmsResponse.builder().payload((Object)true).build();
        }
        catch (CmsRestException cmsRestException) {
            log.info("Couldn't update authorisation status by authorisation ID {}, HTTP response status: {}", (Object)authorisationId, (Object)cmsRestException.getHttpStatus());
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    public CmsResponse<List<String>> getAuthorisationsByParentId(AuthorisationParentHolder parentHolder) {
        String parentId = parentHolder.getParentId();
        try {
            ResponseEntity request = this.consentRestTemplate.exchange(this.authorisationRemoteUrls.getAuthorisationsByParentId(), HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, new Object[]{parentHolder.getAuthorisationType(), parentId});
            return CmsResponse.builder().payload(request.getBody()).build();
        }
        catch (CmsRestException cmsRestException) {
            log.info("Couldn't get authorisations by parent ID {}, HTTP response status: {}", (Object)parentId, (Object)cmsRestException.getHttpStatus());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<ScaStatus> getAuthorisationScaStatus(String authorisationId, AuthorisationParentHolder parentHolder) {
        String parentId = parentHolder.getParentId();
        try {
            ResponseEntity request = this.consentRestTemplate.getForEntity(this.authorisationRemoteUrls.getAuthorisationScaStatus(), ScaStatus.class, new Object[]{parentHolder.getAuthorisationType(), parentId, authorisationId});
            return CmsResponse.builder().payload(request.getBody()).build();
        }
        catch (CmsRestException cmsRestException) {
            log.info("Couldn't get SCA Status by parent ID {} and authorisation ID {}, HTTP response status: {}", new Object[]{parentId, authorisationId, cmsRestException.getHttpStatus()});
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<Boolean> isAuthenticationMethodDecoupled(String authorisationId, String authenticationMethodId) {
        Boolean body = (Boolean)this.consentRestTemplate.getForEntity(this.authorisationRemoteUrls.isAuthenticationMethodDecoupled(), Boolean.class, new Object[]{authorisationId, authenticationMethodId}).getBody();
        return CmsResponse.builder().payload((Object)body).build();
    }

    public CmsResponse<Boolean> saveAuthenticationMethods(String authorisationId, List<CmsScaMethod> methods) {
        try {
            ResponseEntity responseEntity = this.consentRestTemplate.exchange(this.authorisationRemoteUrls.saveAuthenticationMethods(), HttpMethod.POST, new HttpEntity(methods), Void.class, new Object[]{authorisationId});
            if (responseEntity.getStatusCode() == HttpStatus.NO_CONTENT) {
                return CmsResponse.builder().payload((Object)true).build();
            }
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Couldn't save authentication methods {} by authorisation ID {}, HTTP response status: {}", new Object[]{methods, authorisationId, cmsRestException.getHttpStatus()});
        }
        return CmsResponse.builder().payload((Object)false).build();
    }

    public CmsResponse<Boolean> updateScaApproach(String authorisationId, ScaApproach scaApproach) {
        try {
            Boolean body = (Boolean)this.consentRestTemplate.exchange(this.authorisationRemoteUrls.updateScaApproach(), HttpMethod.PUT, null, Boolean.class, new Object[]{authorisationId, scaApproach}).getBody();
            return CmsResponse.builder().payload((Object)body).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Couldn't update SCA approach {} by authorisation ID {}, HTTP response status: {}", new Object[]{scaApproach, authorisationId, cmsRestException.getHttpStatus()});
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    public CmsResponse<AuthorisationScaApproachResponse> getAuthorisationScaApproach(String authorisationId) {
        try {
            ResponseEntity request = this.consentRestTemplate.getForEntity(this.authorisationRemoteUrls.getAuthorisationScaApproach(), AuthorisationScaApproachResponse.class, new Object[]{authorisationId});
            return CmsResponse.builder().payload(request.getBody()).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Couldn't get SCA Approach by authorisation ID {}, HTTP response status: {}", (Object)authorisationId, (Object)cmsRestException.getHttpStatus());
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    @ConstructorProperties(value={"consentRestTemplate", "authorisationRemoteUrls"})
    public AuthorisationServiceRemote(RestTemplate consentRestTemplate, AuthorisationRemoteUrls authorisationRemoteUrls) {
        this.consentRestTemplate = consentRestTemplate;
        this.authorisationRemoteUrls = authorisationRemoteUrls;
    }
}

