/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.PiisConsentService;
import de.adorsys.psd2.consent.config.CmsRestException;
import de.adorsys.psd2.consent.config.PiisConsentRemoteUrls;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class PiisConsentServiceRemote
implements PiisConsentService {
    private static final Logger log = LoggerFactory.getLogger(PiisConsentServiceRemote.class);
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final PiisConsentRemoteUrls remotePiisConsentUrls;

    public CmsResponse<List<PiisConsent>> getPiisConsentListByAccountIdentifier(Currency currency, AccountReferenceSelector accountReferenceSelector) {
        List response = Collections.emptyList();
        HttpHeaders headers = new HttpHeaders();
        headers.set("currency", currency == null ? null : currency.toString());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            response = (List)this.consentRestTemplate.exchange(this.remotePiisConsentUrls.getPiisConsent(), HttpMethod.GET, entity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<PiisConsent>>(){}, new Object[]{accountReferenceSelector.getAccountReferenceType().name(), accountReferenceSelector.getAccountValue()}).getBody();
        }
        catch (CmsRestException e) {
            log.error("Failed to retrieve piis consent validation data");
        }
        return CmsResponse.builder().payload(response).build();
    }

    @ConstructorProperties(value={"consentRestTemplate", "remotePiisConsentUrls"})
    public PiisConsentServiceRemote(RestTemplate consentRestTemplate, PiisConsentRemoteUrls remotePiisConsentUrls) {
        this.consentRestTemplate = consentRestTemplate;
        this.remotePiisConsentUrls = remotePiisConsentUrls;
    }
}

