/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.pis.CreatePisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentRequest;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentInfo;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.consent.config.CmsRestException;
import de.adorsys.psd2.consent.config.PisCommonPaymentRemoteUrls;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class PisCommonPaymentServiceRemote
implements PisCommonPaymentServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(PisCommonPaymentServiceRemote.class);
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final PisCommonPaymentRemoteUrls remotePisCommonPaymentUrls;

    public CmsResponse<CreatePisCommonPaymentResponse> createCommonPayment(PisPaymentInfo request) {
        try {
            CreatePisCommonPaymentResponse body = (CreatePisCommonPaymentResponse)this.consentRestTemplate.postForEntity(this.remotePisCommonPaymentUrls.createPisCommonPayment(), (Object)request, CreatePisCommonPaymentResponse.class, new Object[0]).getBody();
            return CmsResponse.builder().payload((Object)body).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote common payment creation failed");
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<TransactionStatus> getPisCommonPaymentStatusById(String paymentId) {
        return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
    }

    public CmsResponse<PisCommonPaymentResponse> getCommonPaymentById(String paymentId) {
        try {
            PisCommonPaymentResponse body = (PisCommonPaymentResponse)this.consentRestTemplate.getForEntity(this.remotePisCommonPaymentUrls.getPisCommonPaymentById(), PisCommonPaymentResponse.class, new Object[]{paymentId}).getBody();
            return CmsResponse.builder().payload((Object)body).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote get common payment by ID failed");
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<Boolean> updateCommonPaymentStatusById(String paymentId, TransactionStatus status) {
        try {
            HttpStatus statusCode = this.consentRestTemplate.exchange(this.remotePisCommonPaymentUrls.updatePisCommonPaymentStatus(), HttpMethod.PUT, null, Void.class, new Object[]{paymentId, status.getTransactionStatus()}).getStatusCode();
            return CmsResponse.builder().payload((Object)(statusCode == HttpStatus.OK ? 1 : 0)).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote update common payment status by ID failed");
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    public CmsResponse<String> getDecryptedId(String encryptedId) {
        try {
            String body = (String)this.consentRestTemplate.getForEntity(this.remotePisCommonPaymentUrls.getPaymentIdByEncryptedString(), String.class, new Object[]{encryptedId}).getBody();
            return CmsResponse.builder().payload((Object)body).build();
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote decrypt encrypted common payment ID failed");
            return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
        }
    }

    public CmsResponse<CmsResponse.VoidResponse> updateCommonPayment(PisCommonPaymentRequest request, String paymentId) {
        this.consentRestTemplate.exchange(this.remotePisCommonPaymentUrls.updatePisCommonPayment(), HttpMethod.PUT, new HttpEntity((Object)request), Void.class, new Object[]{paymentId});
        return CmsResponse.builder().payload((Object)CmsResponse.voidResponse()).build();
    }

    public CmsResponse<Boolean> updateMultilevelSca(String paymentId, boolean multilevelScaRequired) {
        try {
            Boolean body = (Boolean)this.consentRestTemplate.exchange(this.remotePisCommonPaymentUrls.updateMultilevelScaRequired(), HttpMethod.PUT, null, Boolean.class, new Object[]{paymentId, multilevelScaRequired}).getBody();
            return CmsResponse.builder().payload((Object)body).build();
        }
        catch (CmsRestException cmsRestException) {
            log.info("Payment ID: [{}]. No payment could be found by given payment ID.", (Object)paymentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    public CmsResponse<List<PsuIdData>> getPsuDataListByPaymentId(String paymentId) {
        try {
            PsuIdData[] body = (PsuIdData[])this.consentRestTemplate.getForEntity(this.remotePisCommonPaymentUrls.getPsuDataByPaymentId(), PsuIdData[].class, new Object[]{paymentId}).getBody();
            if (body != null) {
                return CmsResponse.builder().payload(Arrays.asList(body)).build();
            }
        }
        catch (CmsRestException cmsRestException) {
            log.warn("Remote get PSU data list by paymentId {} failed", (Object)paymentId);
        }
        return CmsResponse.builder().error(CmsError.TECHNICAL_ERROR).build();
    }

    @ConstructorProperties(value={"consentRestTemplate", "remotePisCommonPaymentUrls"})
    public PisCommonPaymentServiceRemote(RestTemplate consentRestTemplate, PisCommonPaymentRemoteUrls remotePisCommonPaymentUrls) {
        this.consentRestTemplate = consentRestTemplate;
        this.remotePisCommonPaymentUrls = remotePisCommonPaymentUrls;
    }
}

