/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.TppService;
import de.adorsys.psd2.consent.config.CmsRestException;
import de.adorsys.psd2.consent.config.TppServiceRemoteUrls;
import de.adorsys.psd2.xs2a.core.tpp.TppInfo;
import java.beans.ConstructorProperties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class TppServiceRemote
implements TppService {
    private static final Logger log = LoggerFactory.getLogger(TppServiceRemote.class);
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final TppServiceRemoteUrls tppServiceRemoteUrls;

    public CmsResponse<Boolean> updateTppInfo(@NotNull TppInfo tppInfo) {
        try {
            ResponseEntity responseEntity = this.consentRestTemplate.exchange(this.tppServiceRemoteUrls.updateTppInfo(), HttpMethod.PUT, new HttpEntity((Object)tppInfo), Boolean.class, new Object[0]);
            return CmsResponse.builder().payload(responseEntity.getBody()).build();
        }
        catch (CmsRestException e) {
            log.error("TPP not found, id: {}", (Object)tppInfo.getAuthorisationNumber());
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    @ConstructorProperties(value={"consentRestTemplate", "tppServiceRemoteUrls"})
    public TppServiceRemote(RestTemplate consentRestTemplate, TppServiceRemoteUrls tppServiceRemoteUrls) {
        this.consentRestTemplate = consentRestTemplate;
        this.tppServiceRemoteUrls = tppServiceRemoteUrls;
    }
}

