/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.TppStopListService;
import de.adorsys.psd2.consent.config.TppStopListRemoteUrls;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TppStopListServiceRemote
implements TppStopListService {
    private static final String TPP_AUTHORISATION_NUMBER_HEADER = "tpp-authorisation-number";
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final TppStopListRemoteUrls tppStopListRemoteUrls;

    public CmsResponse<Boolean> checkIfTppBlocked(String tppAuthorisationNumber) {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Accept", (Object)"*/*");
        headers.add((Object)"Content-Type", (Object)"application/json");
        headers.add((Object)TPP_AUTHORISATION_NUMBER_HEADER, (Object)tppAuthorisationNumber);
        Boolean body = (Boolean)this.consentRestTemplate.exchange(this.tppStopListRemoteUrls.checkIfTppBlocked(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), Boolean.class, new Object[0]).getBody();
        return CmsResponse.builder().payload((Object)body).build();
    }

    @ConstructorProperties(value={"consentRestTemplate", "tppStopListRemoteUrls"})
    public TppStopListServiceRemote(RestTemplate consentRestTemplate, TppStopListRemoteUrls tppStopListRemoteUrls) {
        this.consentRestTemplate = consentRestTemplate;
        this.tppStopListRemoteUrls = tppStopListRemoteUrls;
    }
}

