/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.service;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiServiceEncrypted;
import de.adorsys.psd2.consent.config.CmsRestException;
import de.adorsys.psd2.consent.config.PisPaymentRemoteUrls;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class UpdatePaymentAfterSpiServiceRemote
implements UpdatePaymentAfterSpiServiceEncrypted {
    private static final Logger log = LoggerFactory.getLogger(UpdatePaymentAfterSpiServiceRemote.class);
    public static final String PAYMENT_NOT_FOUND_MESSAGE = "Payment not found, id: {}";
    @Qualifier(value="consentRestTemplate")
    private final RestTemplate consentRestTemplate;
    private final PisPaymentRemoteUrls pisPaymentRemoteUrls;

    public CmsResponse<Boolean> updatePaymentStatus(@NotNull String encryptedPaymentId, @NotNull TransactionStatus status) {
        try {
            this.consentRestTemplate.exchange(this.pisPaymentRemoteUrls.updatePaymentStatus(), HttpMethod.PUT, null, Void.class, new Object[]{encryptedPaymentId, status.name()});
            return CmsResponse.builder().payload((Object)true).build();
        }
        catch (CmsRestException e) {
            log.error(PAYMENT_NOT_FOUND_MESSAGE, (Object)encryptedPaymentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    public CmsResponse<Boolean> updatePaymentCancellationTppRedirectUri(@NotNull String encryptedPaymentId, @NotNull TppRedirectUri tppRedirectUri) {
        try {
            LinkedMultiValueMap headers = new LinkedMultiValueMap();
            headers.add((Object)"tpp-redirect-uri", (Object)StringUtils.defaultIfBlank((CharSequence)tppRedirectUri.getUri(), (CharSequence)""));
            headers.add((Object)"tpp-nok-redirect-uri", (Object)StringUtils.defaultIfBlank((CharSequence)tppRedirectUri.getNokUri(), (CharSequence)""));
            this.consentRestTemplate.exchange(this.pisPaymentRemoteUrls.updatePaymentCancellationRedirectURIs(), HttpMethod.PUT, new HttpEntity((MultiValueMap)headers), Void.class, new Object[]{encryptedPaymentId});
            return CmsResponse.builder().payload((Object)true).build();
        }
        catch (CmsRestException e) {
            log.error(PAYMENT_NOT_FOUND_MESSAGE, (Object)encryptedPaymentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    public CmsResponse<Boolean> updatePaymentCancellationInternalRequestId(@NotNull String encryptedPaymentId, @NotNull String internalRequestId) {
        try {
            this.consentRestTemplate.exchange(this.pisPaymentRemoteUrls.updatePaymentCancellationInternalRequestId(), HttpMethod.PUT, null, Void.class, new Object[]{encryptedPaymentId, internalRequestId});
            return CmsResponse.builder().payload((Object)true).build();
        }
        catch (CmsRestException e) {
            log.error(PAYMENT_NOT_FOUND_MESSAGE, (Object)encryptedPaymentId);
            return CmsResponse.builder().payload((Object)false).build();
        }
    }

    @ConstructorProperties(value={"consentRestTemplate", "pisPaymentRemoteUrls"})
    public UpdatePaymentAfterSpiServiceRemote(RestTemplate consentRestTemplate, PisPaymentRemoteUrls pisPaymentRemoteUrls) {
        this.consentRestTemplate = consentRestTemplate;
        this.pisPaymentRemoteUrls = pisPaymentRemoteUrls;
    }
}

