/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.xs2a.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.adorsys.psd2.consent.web.xs2a.config.InternalCmsXs2aApiTagHolder;
import java.beans.ConstructorProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
public class Xs2aApiSwaggerConfig {
    @Value(value="${license.url}")
    private String licenseUrl;
    private final BuildProperties buildProperties;

    @Bean(name={"xs2a-api"})
    public Docket apiDocklet() {
        return new Docket(DocumentationType.SWAGGER_2).groupName("Internal CMS-XS2A-API").apiInfo(this.getApiInfo()).tags(InternalCmsXs2aApiTagHolder.AIS_CONSENTS, new Tag[]{InternalCmsXs2aApiTagHolder.AIS_PSU_DATA, InternalCmsXs2aApiTagHolder.ASPSP_CONSENT_DATA, InternalCmsXs2aApiTagHolder.EVENTS, InternalCmsXs2aApiTagHolder.PIIS_CONSENTS, InternalCmsXs2aApiTagHolder.PIS_COMMON_PAYMENT, InternalCmsXs2aApiTagHolder.PIS_PAYMENTS, InternalCmsXs2aApiTagHolder.PIS_PSU_DATA, InternalCmsXs2aApiTagHolder.TPP}).select().apis(RequestHandlerSelectors.basePackage((String)"de.adorsys.psd2.consent.web.xs2a")).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/error.*?"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/connect.*"))).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/management.*"))).build();
    }

    private ApiInfo getApiInfo() {
        return new ApiInfoBuilder().title("XS2A CMS Internal API").contact(new Contact("adorsys GmbH & Co. KG", "https://adorsys-platform.de/solutions/", "psd2@adorsys.de")).version(this.buildProperties.getVersion() + " " + this.buildProperties.get("build.number")).license("Apache License 2.0").licenseUrl(this.licenseUrl).build();
    }

    @ConstructorProperties(value={"buildProperties"})
    public Xs2aApiSwaggerConfig(BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }
}

