/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.xs2a.controller;

import de.adorsys.psd2.consent.api.CmsError;
import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.CmsScaMethod;
import de.adorsys.psd2.consent.api.WrongChecksumException;
import de.adorsys.psd2.consent.api.ais.AisAccountAccessInfo;
import de.adorsys.psd2.consent.api.ais.AisAccountConsent;
import de.adorsys.psd2.consent.api.ais.AisConsentActionRequest;
import de.adorsys.psd2.consent.api.ais.AisConsentStatusResponse;
import de.adorsys.psd2.consent.api.ais.CreateAisConsentRequest;
import de.adorsys.psd2.consent.api.ais.UpdateAisConsentResponse;
import de.adorsys.psd2.consent.api.authorisation.AisAuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.AuthorisationParentHolder;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationRequest;
import de.adorsys.psd2.consent.api.authorisation.CreateAuthorisationResponse;
import de.adorsys.psd2.consent.api.authorisation.UpdateAuthorisationRequest;
import de.adorsys.psd2.consent.api.service.AccountServiceEncrypted;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.consent.api.service.AuthorisationServiceEncrypted;
import de.adorsys.psd2.xs2a.core.authorisation.Authorisation;
import de.adorsys.psd2.xs2a.core.consent.ConsentStatus;
import de.adorsys.psd2.xs2a.core.profile.ScaApproach;
import de.adorsys.psd2.xs2a.core.sca.AuthorisationScaApproachResponse;
import de.adorsys.psd2.xs2a.core.sca.ScaStatus;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/ais/consent"})
@Api(value="api/v1/ais/consent", tags={"AIS, Consents"})
public class AisConsentController {
    private final AuthorisationServiceEncrypted authorisationServiceEncrypted;
    private final AisConsentServiceEncrypted aisConsentService;
    private final AccountServiceEncrypted accountServiceEncrypted;

    @PostMapping(path={"/"})
    @ApiOperation(value="Create consent for given psu id and accesses.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=String.class), @ApiResponse(code=400, message="Checksum verification failed"), @ApiResponse(code=204, message="No Content")})
    public ResponseEntity createConsent(@RequestBody CreateAisConsentRequest request) {
        CmsResponse cmsResponse;
        try {
            cmsResponse = this.aisConsentService.createConsent(request);
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity((Object)CmsError.CHECKSUM_ERROR, HttpStatus.BAD_REQUEST);
        }
        if (cmsResponse.hasError()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(cmsResponse.getPayload(), HttpStatus.CREATED);
    }

    @PostMapping(path={"/action"})
    @ApiOperation(value="Save information about uses of consent")
    public ResponseEntity saveConsentActionLog(@RequestBody AisConsentActionRequest request) {
        try {
            this.aisConsentService.checkConsentAndSaveActionLog(request);
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity((Object)CmsError.CHECKSUM_ERROR, HttpStatus.BAD_REQUEST);
        }
        return ResponseEntity.ok().build();
    }

    @GetMapping(path={"/{consent-id}"})
    @ApiOperation(value="Read account consent by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=AisAccountConsent.class), @ApiResponse(code=204, message="No Content")})
    public ResponseEntity<AisAccountConsent> getConsentById(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId) {
        CmsResponse consentById = this.aisConsentService.getAisAccountConsentById(consentId);
        if (consentById.hasError()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(consentById.getPayload(), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/access"})
    @ApiOperation(value="Update AccountAccess in the consent identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Checksum verification failed"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity updateAccountAccess(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId, @RequestBody AisAccountAccessInfo request) {
        CmsResponse response;
        try {
            response = this.aisConsentService.updateAspspAccountAccessWithResponse(consentId, request);
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity((Object)CmsError.CHECKSUM_ERROR, HttpStatus.BAD_REQUEST);
        }
        if (response.hasError()) {
            return new ResponseEntity((Object)response.getError(), HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)new UpdateAisConsentResponse((AisAccountConsent)response.getPayload()), HttpStatus.OK);
    }

    @GetMapping(path={"/{consent-id}/status"})
    @ApiOperation(value="Can check the status of an account information consent resource.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ConsentStatus.class), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AisConsentStatusResponse> getConsentStatusById(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId) {
        CmsResponse consentStatusById = this.aisConsentService.getConsentStatusById(consentId);
        if (consentStatusById.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new AisConsentStatusResponse((ConsentStatus)consentStatusById.getPayload()), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/status/{status}"})
    @ApiOperation(value="Update consent status in the consent identified by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Checksum verification failed"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity updateConsentStatus(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId, @ApiParam(value="The following code values are permitted 'VALID', 'REJECTED', 'REVOKED_BY_PSU', 'TERMINATED_BY_TPP'. These values might be extended by ASPSP by more values.", example="VALID", required=true) @PathVariable(value="status") String status) {
        CmsResponse response;
        try {
            response = this.aisConsentService.updateConsentStatusById(consentId, ConsentStatus.valueOf((String)status));
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity((Object)CmsError.CHECKSUM_ERROR, HttpStatus.BAD_REQUEST);
        }
        if (response.isSuccessful() && ((Boolean)response.getPayload()).booleanValue()) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(path={"/{consent-id}/old-consents"})
    @ApiOperation(value="Find old consents for current TPP and PSU and terminates them")
    @ApiResponse(code=204, message="No Content")
    public ResponseEntity<Void> findAndTerminateOldConsentsByNewConsentId(@ApiParam(name="consent-id", value="The account consent identification assigned to the new account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId) {
        this.aisConsentService.findAndTerminateOldConsentsByNewConsentId(consentId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(path={"/{consent-id}/authorizations"})
    @ApiOperation(value="Create consent authorization for given consent id.")
    @ApiResponses(value={@ApiResponse(code=201, message="Created"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<CreateAuthorisationResponse> createConsentAuthorization(@ApiParam(name="consent-id", value="The consent identification assigned to the created consent authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId, @RequestBody CreateAuthorisationRequest authorisationRequest) {
        CmsResponse response = this.authorisationServiceEncrypted.createAuthorisation((AuthorisationParentHolder)new AisAuthorisationParentHolder(consentId), authorisationRequest);
        if (response.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(response.getPayload(), HttpStatus.CREATED);
    }

    @PutMapping(path={"/authorizations/{authorization-id}"})
    @ApiOperation(value="Update consent authorization.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> updateConsentAuthorization(@ApiParam(name="authorization-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorization-id") String authorizationId, @ApiParam(value="The following code values are permitted 'VALID', 'REJECTED', 'REVOKED_BY_PSU', 'TERMINATED_BY_TPP'. These values might be extended by ASPSP by more values.", example="VALID") @RequestBody UpdateAuthorisationRequest authorisationRequest) {
        CmsResponse response = this.authorisationServiceEncrypted.updateAuthorisation(authorizationId, authorisationRequest);
        if (response.isSuccessful() && response.getPayload() != null && ((Authorisation)response.getPayload()).getParentId() != null) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PutMapping(path={"/authorisations/{authorisation-id}/status/{status}"})
    @ApiOperation(value="Update consent authorisation status.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> updateConsentAuthorisationStatus(@ApiParam(name="authorisation-id", value="The consent authorisation identification assigned to the created authorisation.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String authorisationId, @ApiParam(value="The following code values are permitted 'VALID', 'REJECTED', 'REVOKED_BY_PSU', 'TERMINATED_BY_TPP'. These values might be extended by ASPSP by more values.", example="VALID", required=true) @PathVariable(value="status") String scaStatus) {
        CmsResponse response = this.authorisationServiceEncrypted.updateAuthorisationStatus(authorisationId, ScaStatus.fromValue((String)scaStatus));
        if (response.isSuccessful() && ((Boolean)response.getPayload()).booleanValue()) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @GetMapping(path={"/{consent-id}/authorizations/{authorization-id}"})
    @ApiOperation(value="Getting consent authorization.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Authorisation> getConsentAuthorization(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId, @ApiParam(name="authorization-id", value="The consent authorization identification assigned to the created authorization.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorization-id") String authorizationId) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationById(authorizationId);
        if (response.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(response.getPayload(), HttpStatus.OK);
    }

    @GetMapping(path={"/{consent-id}/authorisations/{authorisation-id}/status"})
    @ApiOperation(value="Gets SCA status of consent authorisation.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<ScaStatus> getConsentAuthorizationScaStatus(@ApiParam(name="consent-id", value="Account consent identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId, @ApiParam(name="authorisation-id", value="Consent authorisation identification", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String authorisationId) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationScaStatus(authorisationId, (AuthorisationParentHolder)new AisAuthorisationParentHolder(consentId));
        if (response.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(response.getPayload(), HttpStatus.OK);
    }

    @GetMapping(path={"/{consent-id}/authorisations"})
    @ApiOperation(value="Gets list of consent authorisation IDs by consent ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<String>> getConsentAuthorisation(@ApiParam(name="consent-id", value="The account consent identification assigned to the created account consent.", example="vOHy6fj2f5IgxHk-kTlhw6sZdTXbRE3bWsu2obq54beYOChP5NvRmfh06nrwumc2R01HygQenchEcdGOlU-U0A==_=_iR74m2PdNyE", required=true) @PathVariable(value="consent-id") String consentId) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationsByParentId((AuthorisationParentHolder)new AisAuthorisationParentHolder(consentId));
        if (response.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(response.getPayload(), HttpStatus.OK);
    }

    @GetMapping(path={"/authorisations/{authorisation-id}/authentication-methods/{authentication-method-id}"})
    @ApiOperation(value="Checks if requested authentication method is decoupled")
    @ApiResponse(code=200, message="OK")
    public ResponseEntity<Boolean> isAuthenticationMethodDecoupled(@ApiParam(name="authorisation-id", value="Consent authorisation identification", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String authorisationId, @ApiParam(name="authentication-method-id", value="Authentication method identification", example="sms", required=true) @PathVariable(value="authentication-method-id") String authenticationMethodId) {
        CmsResponse response = this.authorisationServiceEncrypted.isAuthenticationMethodDecoupled(authorisationId, authenticationMethodId);
        return new ResponseEntity(response.getPayload(), HttpStatus.OK);
    }

    @PostMapping(path={"/authorisations/{authorisation-id}/authentication-methods"})
    @ApiOperation(value="Saves authentication methods in authorisation")
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Void> saveAuthenticationMethods(@ApiParam(name="authorisation-id", value="The consent authorisation identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String authorisationId, @RequestBody List<CmsScaMethod> methods) {
        CmsResponse response = this.authorisationServiceEncrypted.saveAuthenticationMethods(authorisationId, methods);
        if (response.isSuccessful() && ((Boolean)response.getPayload()).booleanValue()) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PutMapping(path={"/authorisations/{authorisation-id}/sca-approach/{sca-approach}"})
    @ApiOperation(value="Updates AIS SCA approach in authorisation")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> updateScaApproach(@ApiParam(name="authorisation-id", value="The consent authorisation identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String authorisationId, @ApiParam(name="sca-approach", value="Chosen SCA approach.", example="REDIRECT", required=true) @PathVariable(value="sca-approach") ScaApproach scaApproach) {
        CmsResponse response = this.authorisationServiceEncrypted.updateScaApproach(authorisationId, scaApproach);
        if (response.isSuccessful() && ((Boolean)response.getPayload()).booleanValue()) {
            return new ResponseEntity((Object)true, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @PutMapping(path={"/{consent-id}/multilevel-sca"})
    @ApiOperation(value="Updates multilevel SCA in consent")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Checksum verification failed"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity updateMultilevelScaRequired(@ApiParam(name="consent-id", value="The consent identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId, @ApiParam(name="multilevel-sca", value="Multilevel SCA.", example="false") @RequestParam(value="multilevel-sca", defaultValue="false") boolean multilevelSca) {
        CmsResponse response;
        try {
            response = this.aisConsentService.updateMultilevelScaRequired(consentId, multilevelSca);
        }
        catch (WrongChecksumException e) {
            return new ResponseEntity((Object)CmsError.CHECKSUM_ERROR, HttpStatus.BAD_REQUEST);
        }
        if (response.isSuccessful() && ((Boolean)response.getPayload()).booleanValue()) {
            return new ResponseEntity((Object)true, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @GetMapping(path={"/authorisations/{authorisation-id}/sca-approach"})
    @ApiOperation(value="Gets SCA approach of the consent authorisation by its ID")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<AuthorisationScaApproachResponse> getAuthorisationScaApproach(@ApiParam(name="authorisation-id", value="The consent authorisation identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="authorisation-id") String authorisationId) {
        CmsResponse response = this.authorisationServiceEncrypted.getAuthorisationScaApproach(authorisationId);
        if (response.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(response.getPayload(), HttpStatus.OK);
    }

    @PutMapping(path={"/{consent-id}/{resource-id}"})
    @ApiOperation(value="Saves number of transactions for a definite account of the definite consent")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<Boolean> saveNumberOfTransactions(@ApiParam(name="consent-id", value="The consent identification.", example="bf489af6-a2cb-4b75-b71d-d66d58b934d7", required=true) @PathVariable(value="consent-id") String consentId, @PathVariable(value="resource-id") String resourceId, @RequestBody Integer numberOfTransactions) {
        return this.accountServiceEncrypted.saveNumberOfTransactions(consentId, resourceId, numberOfTransactions.intValue()) ? new ResponseEntity((Object)true, HttpStatus.OK) : new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @ConstructorProperties(value={"authorisationServiceEncrypted", "aisConsentService", "accountServiceEncrypted"})
    public AisConsentController(AuthorisationServiceEncrypted authorisationServiceEncrypted, AisConsentServiceEncrypted aisConsentService, AccountServiceEncrypted accountServiceEncrypted) {
        this.authorisationServiceEncrypted = authorisationServiceEncrypted;
        this.aisConsentService = aisConsentService;
        this.accountServiceEncrypted = accountServiceEncrypted;
    }
}

