/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.xs2a.controller;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.AisConsentServiceEncrypted;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/ais"})
@Api(value="api/v1/ais", tags={"AIS, PSU Data"})
public class AisPsuDataController {
    private final AisConsentServiceEncrypted aisConsentService;

    @GetMapping(path={"/consent/{consent-id}/psu-data"})
    @ApiOperation(value="Get psu data list by given consent id.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<PsuIdData>> getPsuDataByConsentId(@ApiParam(name="consent-id", value="The consent identification.", example="32454656712432", required=true) @PathVariable(value="consent-id") String consentId) {
        CmsResponse psuDataResponse = this.aisConsentService.getPsuDataByConsentId(consentId);
        if (psuDataResponse.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(psuDataResponse.getPayload(), HttpStatus.OK);
    }

    @ConstructorProperties(value={"aisConsentService"})
    public AisPsuDataController(AisConsentServiceEncrypted aisConsentService) {
        this.aisConsentService = aisConsentService;
    }
}

