/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.xs2a.controller;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.PiisConsentService;
import de.adorsys.psd2.xs2a.core.piis.PiisConsent;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceSelector;
import de.adorsys.psd2.xs2a.core.profile.AccountReferenceType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/piis/consent"})
@Api(value="api/v1/piis/consent", tags={"PIIS, Consents"})
public class PiisConsentController {
    private final PiisConsentService piisConsentService;

    @GetMapping(path={"/{account-reference-type}/{account-identifier}"})
    @ApiOperation(value="Gets list of consents by account reference data.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<List<PiisConsent>> getPiisConsentListByAccountReference(@ApiParam(name="currency", value="3 capital letters of currency name.", example="EUR") @RequestHeader(value="currency") String currency, @ApiParam(name="account-reference-type", value="Account reference type, can be either IBAN, BBAN, PAN, MSISDN or MASKED_PAN.", example="IBAN", required=true) @PathVariable(value="account-reference-type") AccountReferenceType accountReferenceType, @ApiParam(name="account-identifier", value="The value of account identifier.", example="DE2310010010123456789", required=true) @PathVariable(value="account-identifier") String accountIdentifier) {
        Currency nullableCurrency = StringUtils.isBlank((CharSequence)currency) ? null : Currency.getInstance(currency);
        CmsResponse response = this.piisConsentService.getPiisConsentListByAccountIdentifier(nullableCurrency, new AccountReferenceSelector(accountReferenceType, accountIdentifier));
        return response.isSuccessful() && CollectionUtils.isNotEmpty((Collection)((Collection)response.getPayload())) ? ResponseEntity.ok((Object)response.getPayload()) : ResponseEntity.notFound().build();
    }

    @ConstructorProperties(value={"piisConsentService"})
    public PiisConsentController(PiisConsentService piisConsentService) {
        this.piisConsentService = piisConsentService;
    }
}

