/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.consent.web.xs2a.controller;

import de.adorsys.psd2.consent.api.CmsResponse;
import de.adorsys.psd2.consent.api.service.PisCommonPaymentServiceEncrypted;
import de.adorsys.psd2.consent.api.service.UpdatePaymentAfterSpiServiceEncrypted;
import de.adorsys.psd2.xs2a.core.pis.TransactionStatus;
import de.adorsys.psd2.xs2a.core.tpp.TppRedirectUri;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.beans.ConstructorProperties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"api/v1/pis"})
@Api(value="api/v1/pis", tags={"PIS, Payments"})
public class PisPaymentController {
    private final PisCommonPaymentServiceEncrypted pisCommonPaymentService;
    private final UpdatePaymentAfterSpiServiceEncrypted updatePaymentStatusAfterSpiService;

    @GetMapping(path={"/payment/{payment-id}"})
    @ApiOperation(value="Get inner payment id by encrypted string")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Not Found")})
    public ResponseEntity<String> getPaymentIdByEncryptedString(@ApiParam(name="payment-id", value="The payment identification.", example="32454656712432", required=true) @PathVariable(value="payment-id") String encryptedId) {
        CmsResponse response = this.pisCommonPaymentService.getDecryptedId(encryptedId);
        if (response.hasError()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(response.getPayload(), HttpStatus.OK);
    }

    @PutMapping(path={"/payment/{payment-id}/status/{status}"})
    @ApiOperation(value="Updates payment status after SPI service. Should not be used for any other purposes!")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<Void> updatePaymentStatusAfterSpiService(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", required=true) @PathVariable(value="payment-id") String paymentId, @ApiParam(value="The following code values are permitted 'ACCC', 'ACCP', 'ACSC', 'ACSP', 'ACTC', 'ACWC', 'ACWP', 'PDNG', 'RJCT', 'RCVD', 'CANC', 'ACFC', 'PATC'. These values might be extended by ASPSP by more values.", allowableValues="ACCC, ACCP, ACSC, ACSP, ACTC, ACWC, ACWP, RCVD, PDNG, RJCT, CANC, ACFC, PATC", required=true) @PathVariable(value="status") String status) {
        CmsResponse response = this.updatePaymentStatusAfterSpiService.updatePaymentStatus(paymentId, TransactionStatus.valueOf((String)status));
        if (response.isSuccessful() && ((Boolean)response.getPayload()).booleanValue()) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @PutMapping(path={"/payment/{payment-id}/cancellation/redirects"})
    @ApiOperation(value="Updates payment cancellation redirect URIs after SPI service. Should not be used for any other purposes!")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<Void> updatePaymentCancellationTppRedirectUri(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", required=true) @PathVariable(value="payment-id") String paymentId, @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI) {
        CmsResponse response = this.updatePaymentStatusAfterSpiService.updatePaymentCancellationTppRedirectUri(paymentId, new TppRedirectUri((String)StringUtils.defaultIfBlank((CharSequence)tpPRedirectURI, (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)tpPNokRedirectURI, (CharSequence)"")));
        if (response.isSuccessful() && ((Boolean)response.getPayload()).booleanValue()) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @PutMapping(path={"/payment/{payment-id}/cancellation/internal-request-id/{internal-request-id}"})
    @ApiOperation(value="Updates payment cancellation internal request ID after SPI service. Should not be used for any other purposes!")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request")})
    public ResponseEntity<Void> updatePaymentCancellationInternalRequestId(@ApiParam(name="payment-id", value="The payment identification assigned to the created payment.", required=true) @PathVariable(value="payment-id") String paymentId, @ApiParam(name="internal-request-id", value="Cancellation internal request ID of payment.", required=true) @PathVariable(value="internal-request-id") String internalRequestId) {
        CmsResponse response = this.updatePaymentStatusAfterSpiService.updatePaymentCancellationInternalRequestId(paymentId, internalRequestId);
        if (response.isSuccessful() && ((Boolean)response.getPayload()).booleanValue()) {
            return new ResponseEntity(HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    @ConstructorProperties(value={"pisCommonPaymentService", "updatePaymentStatusAfterSpiService"})
    public PisPaymentController(PisCommonPaymentServiceEncrypted pisCommonPaymentService, UpdatePaymentAfterSpiServiceEncrypted updatePaymentStatusAfterSpiService) {
        this.pisCommonPaymentService = pisCommonPaymentService;
        this.updatePaymentStatusAfterSpiService = updatePaymentStatusAfterSpiService;
    }
}

